(ns exchange.db.protocol)

(defprotocol ExchangeDb
  "兑换服务的数据接口实现"

  (user-tickets [_ topic username]
    "获取用户在某次活动中获得的奖券信息")

  (add-ticket [_ ticket]
    "增加用户的奖券")

  (update-tickets [_ topic username tickets-delta]
    "更新用户的奖券数量")

  (users-exchanged-ticket [_ topic ticket-name]
    "获取各用户已兑换的奖卷数量(大于0)")

  (exchange-ticket [_ record]
    "保存一条兑换记录,并扣掉可兑换的奖卷数")

  (update-record [_ record]
    "更新兑换记录,用于添加奖品信息")

  (user-record [_ order-id]
    "获取用户的兑换记录")

  (user-records [_ topic username]
    "获取用户的兑换记录")

  (prize-records [_ topic prize-name]
    "获取奖品的兑换记录")

  (prizes-count [_ topic [start end] prizes]
    "获取各奖品的兑换数量")

  (recent-records [_ topic prize-filter num]
    "获取最新特定奖品类型的兑换记录"))

(defmulti mk-exchange-db "兑换服务数据库构造器" :type)
