/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public class GenericUDFUtils {
    private static Log LOG = LogFactory.getLog((String)GenericUDFUtils.class.getName());

    public static boolean isUtfStartByte(byte b) {
        return (b & 0xC0) != 128;
    }

    public static String getOrdinal(int i) {
        int unit = i % 10;
        return i <= 0 ? "" : (i != 11 && unit == 1 ? i + "st" : (i != 12 && unit == 2 ? i + "nd" : (i != 13 && unit == 3 ? i + "rd" : i + "th")));
    }

    public static int findText(Text text, Text subtext, int start) {
        if (start < 0) {
            return -1;
        }
        ByteBuffer src = ByteBuffer.wrap(text.getBytes(), 0, text.getLength());
        ByteBuffer tgt = ByteBuffer.wrap(subtext.getBytes(), 0, subtext.getLength());
        byte b = tgt.get();
        src.position(start);
        while (src.hasRemaining()) {
            if (b != src.get()) continue;
            src.mark();
            tgt.mark();
            boolean found = true;
            int pos = src.position() - 1;
            while (tgt.hasRemaining()) {
                if (!src.hasRemaining()) {
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (tgt.get() == src.get()) continue;
                tgt.reset();
                src.reset();
                found = false;
                break;
            }
            if (!found) continue;
            return pos;
        }
        return -1;
    }

    public static class ConversionHelper {
        private Method m;
        private ObjectInspector[] givenParameterOIs;
        Type[] methodParameterTypes;
        private boolean isVariableLengthArgument;
        Type lastParaElementType;
        boolean conversionNeeded;
        ObjectInspectorConverters.Converter[] converters;
        Object[] convertedParameters;
        Object[] convertedParametersInArray;

        private static Class<?> getClassFromType(Type t) {
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                return (Class)pt.getRawType();
            }
            return null;
        }

        public ConversionHelper(Method m, ObjectInspector[] parameterOIs) throws UDFArgumentException {
            this.m = m;
            this.givenParameterOIs = parameterOIs;
            this.methodParameterTypes = m.getGenericParameterTypes();
            this.lastParaElementType = TypeInfoUtils.getArrayElementType(this.methodParameterTypes.length == 0 ? null : this.methodParameterTypes[this.methodParameterTypes.length - 1]);
            this.isVariableLengthArgument = this.lastParaElementType != null;
            ObjectInspector[] methodParameterOIs = new ObjectInspector[parameterOIs.length];
            if (this.isVariableLengthArgument) {
                int i;
                if (parameterOIs.length < this.methodParameterTypes.length - 1) {
                    throw new UDFArgumentLengthException(m.toString() + " requires at least " + (this.methodParameterTypes.length - 1) + " arguments but only " + parameterOIs.length + " are passed in.");
                }
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector(this.methodParameterTypes[i], ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
                if (this.lastParaElementType == Object.class) {
                    for (i = this.methodParameterTypes.length - 1; i < parameterOIs.length; ++i) {
                        methodParameterOIs[i] = ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    }
                } else {
                    ObjectInspector oi = ObjectInspectorFactory.getReflectionObjectInspector(this.lastParaElementType, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                    for (int i2 = this.methodParameterTypes.length - 1; i2 < parameterOIs.length; ++i2) {
                        methodParameterOIs[i2] = oi;
                    }
                }
            } else {
                if (this.methodParameterTypes.length != parameterOIs.length) {
                    throw new UDFArgumentLengthException(m.toString() + " requires " + this.methodParameterTypes.length + " arguments but " + parameterOIs.length + " are passed in.");
                }
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector(this.methodParameterTypes[i], ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
            }
            this.conversionNeeded = false;
            this.converters = new ObjectInspectorConverters.Converter[parameterOIs.length];
            for (int i = 0; i < parameterOIs.length; ++i) {
                ObjectInspectorConverters.Converter pc;
                this.converters[i] = pc = ObjectInspectorConverters.getConverter(parameterOIs[i], methodParameterOIs[i]);
                this.conversionNeeded = this.conversionNeeded || !(pc instanceof ObjectInspectorConverters.IdentityConverter);
            }
            if (this.isVariableLengthArgument) {
                this.convertedParameters = new Object[this.methodParameterTypes.length];
                this.convertedParameters[this.convertedParameters.length - 1] = this.convertedParametersInArray = (Object[])Array.newInstance(ConversionHelper.getClassFromType(this.lastParaElementType), parameterOIs.length - this.methodParameterTypes.length + 1);
            } else {
                this.convertedParameters = new Object[parameterOIs.length];
            }
        }

        public Object[] convertIfNecessary(Object ... parameters) {
            assert (parameters.length == this.givenParameterOIs.length);
            if (!this.conversionNeeded && !this.isVariableLengthArgument) {
                return parameters;
            }
            if (this.isVariableLengthArgument) {
                int i;
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
                for (i = this.methodParameterTypes.length - 1; i < parameters.length; ++i) {
                    this.convertedParametersInArray[i + 1 - this.methodParameterTypes.length] = this.converters[i].convert(parameters[i]);
                }
            } else {
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
            }
            return this.convertedParameters;
        }
    }

    public static class ReturnObjectInspectorResolver {
        boolean allowTypeConversion;
        ObjectInspector returnObjectInspector;
        HashMap<ObjectInspector, ObjectInspectorConverters.Converter> converters;

        public ReturnObjectInspectorResolver() {
            this(false);
        }

        public ReturnObjectInspectorResolver(boolean allowTypeConversion) {
            this.allowTypeConversion = allowTypeConversion;
        }

        public boolean update(ObjectInspector oi) throws UDFArgumentTypeException {
            TypeInfo rTypeInfo;
            if (oi instanceof VoidObjectInspector) {
                return true;
            }
            if (this.returnObjectInspector == null) {
                this.returnObjectInspector = oi;
                return true;
            }
            if (this.returnObjectInspector == oi) {
                return true;
            }
            TypeInfo oiTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(oi);
            if (oiTypeInfo == (rTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(this.returnObjectInspector))) {
                this.returnObjectInspector = ObjectInspectorUtils.getStandardObjectInspector(this.returnObjectInspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                return true;
            }
            if (!this.allowTypeConversion) {
                return false;
            }
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClass(oiTypeInfo, rTypeInfo);
            if (commonTypeInfo == null) {
                return false;
            }
            this.returnObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(commonTypeInfo);
            return true;
        }

        public ObjectInspector get() {
            return this.returnObjectInspector;
        }

        public Object convertIfNecessary(Object o, ObjectInspector oi) {
            Object converted = null;
            if (oi == this.returnObjectInspector) {
                converted = o;
            } else {
                ObjectInspectorConverters.Converter converter;
                if (o == null) {
                    return null;
                }
                if (this.converters == null) {
                    this.converters = new HashMap();
                }
                if ((converter = this.converters.get(oi)) == null) {
                    converter = ObjectInspectorConverters.getConverter(oi, this.returnObjectInspector);
                    this.converters.put(oi, converter);
                }
                converted = converter.convert(o);
            }
            return converted;
        }
    }
}

