/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.HashMap;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@description(name="map", value="_FUNC_(key0, value0, key1, value1...) - Creates a map with the given key/value pairs ")
public class GenericUDFMap
extends GenericUDF {
    ObjectInspectorConverters.Converter[] converters;
    HashMap<Object, Object> ret = new HashMap();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length % 2 != 0) {
            throw new UDFArgumentLengthException("Arguments must be in key/value pairs");
        }
        GenericUDFUtils.ReturnObjectInspectorResolver keyOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        GenericUDFUtils.ReturnObjectInspectorResolver valueOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        for (int i = 0; i < arguments.length; ++i) {
            if (i % 2 == 0) {
                if (!(arguments[i] instanceof PrimitiveObjectInspector)) {
                    throw new UDFArgumentTypeException(1, "Primitive Type is expected but " + arguments[i].getTypeName() + "\" is found");
                }
                if (keyOIResolver.update(arguments[i])) continue;
                throw new UDFArgumentTypeException(i, "Key type \"" + arguments[i].getTypeName() + "\" is different from preceding key types. " + "Previous key type was \"" + arguments[i - 2].getTypeName() + "\"");
            }
            if (valueOIResolver.update(arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "Value type \"" + arguments[i].getTypeName() + "\" is different from preceding value types. " + "Previous value type was \"" + arguments[i - 2].getTypeName() + "\"");
        }
        ObjectInspector keyOI = keyOIResolver.get();
        ObjectInspector valueOI = valueOIResolver.get();
        if (keyOI == null) {
            keyOI = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        if (valueOI == null) {
            valueOI = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter(arguments[i], i % 2 == 0 ? keyOI : valueOI);
        }
        return ObjectInspectorFactory.getStandardMapObjectInspector(keyOI, valueOI);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.ret.clear();
        for (int i = 0; i < arguments.length; i += 2) {
            this.ret.put(this.converters[i].convert(arguments[i].get()), this.converters[i + 1].convert(arguments[i + 1].get()));
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("map(");
        assert (children.length % 2 == 0);
        for (int i = 0; i < children.length; i += 2) {
            sb.append(children[i]);
            sb.append(":");
            sb.append(children[i + 1]);
            if (i + 2 == children.length) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

