/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.Text;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@description(name="get_json_object", value="_FUNC_(json_txt, path) - Extract a json object from path ", extended="Extract json object from a json string based on json path specified, and return json string of the extracted json object. It will return null if the input json string is invalid.\nA limited version of JSONPath supported:\n  $   : Root object\n  .   : Child operator\n  []  : Subscript operator for array\n  *   : Wildcard for []\nSyntax not supported that's worth noticing:\n  ''  : Zero length string as key\n  ..  : Recursive descent\n  &amp;#064;   : Current object/element\n  ()  : Script expression\n  ?() : Filter (script) expression.\n  [,] : Union operator\n  [start:end:step] : array slice operator\n")
public class UDFJson
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFJson.class.getName());
    private Pattern patternKey = Pattern.compile("^([a-zA-Z0-9_\\-]+).*");
    private Pattern patternIndex = Pattern.compile("\\[([0-9]+|\\*)\\]");
    static Map<String, Object> extractObjectCache = new HashCache<String, Object>();
    static Map<String, String[]> pathExprCache = new HashCache<String, String[]>();
    static Map<String, ArrayList<String>> indexListCache = new HashCache<String, ArrayList<String>>();
    static Map<String, String> mKeyGroup1Cache = new HashCache<String, String>();
    static Map<String, Boolean> mKeyMatchesCache = new HashCache<String, Boolean>();
    Text result = new Text();
    ArrayList<Object> jsonList = new ArrayList();

    public Text evaluate(String jsonString, String pathString) {
        if (jsonString == null || jsonString == "" || pathString == null || pathString == "") {
            return null;
        }
        try {
            String[] pathExpr = pathExprCache.get(pathString);
            if (pathExpr == null) {
                pathExpr = pathString.split("\\.", -1);
                pathExprCache.put(pathString, pathExpr);
            }
            if (!pathExpr[0].equalsIgnoreCase("$")) {
                return null;
            }
            Object extractObject = extractObjectCache.get(jsonString);
            if (extractObject == null) {
                extractObject = new JSONObject(jsonString);
                extractObjectCache.put(jsonString, extractObject);
            }
            for (int i = 1; i < pathExpr.length; ++i) {
                extractObject = this.extract(extractObject, pathExpr[i]);
            }
            this.result.set(extractObject.toString());
            return this.result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object extract(Object json, String path) throws JSONException {
        Matcher mKey = null;
        Boolean mKeyMatches = mKeyMatchesCache.get(path);
        if (mKeyMatches == null) {
            mKey = this.patternKey.matcher(path);
            mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
            mKeyMatchesCache.put(path, mKeyMatches);
        }
        if (!mKeyMatches.booleanValue()) {
            return null;
        }
        String mKeyGroup1 = mKeyGroup1Cache.get(path);
        if (mKeyGroup1 == null) {
            if (mKey == null) {
                mKey = this.patternKey.matcher(path);
            }
            mKeyGroup1 = mKey.group(1);
            mKeyGroup1Cache.put(path, mKeyGroup1);
        }
        json = this.extract_json_withkey(json, mKeyGroup1);
        ArrayList<String> indexList = indexListCache.get(path);
        if (indexList == null) {
            Matcher mIndex = this.patternIndex.matcher(path);
            indexList = new ArrayList();
            while (mIndex.find()) {
                indexList.add(mIndex.group(1));
            }
            indexListCache.put(path, indexList);
        }
        if (indexList.size() > 0) {
            json = this.extract_json_withindex(json, indexList);
        }
        return json;
    }

    private Object extract_json_withindex(Object json, ArrayList<String> indexList) throws JSONException {
        this.jsonList.clear();
        this.jsonList.add(json);
        for (String index : indexList) {
            int i;
            ArrayList<Object> tmp_jsonList = new ArrayList<Object>();
            if (index.equalsIgnoreCase("*")) {
                for (i = 0; i < this.jsonList.size(); ++i) {
                    try {
                        JSONArray array = (JSONArray)this.jsonList.get(i);
                        for (int j = 0; j < array.length(); ++j) {
                            tmp_jsonList.add(array.get(j));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.jsonList = tmp_jsonList;
                continue;
            }
            for (i = 0; i < this.jsonList.size(); ++i) {
                try {
                    tmp_jsonList.add(((JSONArray)this.jsonList.get(i)).get(Integer.parseInt(index)));
                }
                catch (ClassCastException e) {
                    continue;
                }
                catch (JSONException e) {
                    return null;
                }
                this.jsonList = tmp_jsonList;
            }
        }
        return this.jsonList.size() > 1 ? new JSONArray(this.jsonList) : this.jsonList.get(0);
    }

    private Object extract_json_withkey(Object json, String path) throws JSONException {
        if (json.getClass() == JSONArray.class) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < ((JSONArray)json).length(); ++i) {
                Object josn_elem = ((JSONArray)json).get(i);
                try {
                    Object json_obj = ((JSONObject)josn_elem).get(path);
                    if (json_obj.getClass() == JSONArray.class) {
                        for (int j = 0; j < ((JSONArray)json_obj).length(); ++j) {
                            jsonArray.put(((JSONArray)json_obj).get(j));
                        }
                        continue;
                    }
                    jsonArray.put(json_obj);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return jsonArray.length() == 0 ? null : jsonArray;
        }
        return ((JSONObject)json).get(path);
    }

    static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

