/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@description(name="from_unixtime", value="_FUNC_(unix_time, format) - returns unix_time in the specified format", extended="Example:\n  > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss') FROM src LIMIT 1;\n  '1970-01-01 00:00:00'")
public class UDFFromUnixTime
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFFromUnixTime.class.getName());
    private SimpleDateFormat formatter;
    Text result = new Text();
    Text lastFormat = new Text();
    Text defaultFormat = new Text("yyyy-MM-dd HH:mm:ss");

    public Text evaluate(IntWritable unixtime) {
        return this.evaluate(unixtime, this.defaultFormat);
    }

    public Text evaluate(LongWritable unixtime, Text format) {
        if (unixtime == null || format == null) {
            return null;
        }
        return this.eval(unixtime.get(), format);
    }

    public Text evaluate(IntWritable unixtime, Text format) {
        if (unixtime == null || format == null) {
            return null;
        }
        return this.eval(unixtime.get(), format);
    }

    private Text eval(long unixtime, Text format) {
        if (!format.equals((Object)this.lastFormat)) {
            this.formatter = new SimpleDateFormat(format.toString());
            this.lastFormat.set(format);
        }
        Date date = new Date(unixtime * 1000L);
        this.result.set(this.formatter.format(date));
        return this.result;
    }
}

