/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="date_sub", value="_FUNC_(start_date, num_days) - Returns the date that is num_days before start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_days is a number. The time part of start_date is ignored.\nExample:\n   > SELECT _FUNC_('2009-30-07', 1) FROM src LIMIT 1;\n  '2009-29-07'")
public class UDFDateSub
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFDateSub.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    Text result = new Text();

    public Text evaluate(Text dateString1, IntWritable days) {
        if (dateString1 == null || days == null) {
            return null;
        }
        try {
            this.calendar.setTime(this.formatter.parse(dateString1.toString()));
            this.calendar.add(5, -days.get());
            Date newDate = this.calendar.getTime();
            this.result.set(this.formatter.format(newDate));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

