/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.ParseError;
import org.apache.hadoop.hive.ql.parse.ParseException;

public class ParseDriver {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.ParseDriver");
    private static HashMap<String, String> xlateMap = new HashMap();
    static final TreeAdaptor adaptor;

    private static String xlate(String name) {
        String ret = xlateMap.get(name);
        if (ret == null) {
            ret = name;
        }
        return ret;
    }

    public ASTNode parse(String command) throws ParseException {
        LOG.info((Object)("Parsing command: " + command));
        HiveLexerX lexer = new HiveLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParserX parser = new HiveParserX((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HiveParser.statement_return r = null;
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.getErrors());
        }
        if (lexer.getErrors().size() != 0 || parser.getErrors().size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.getErrors());
        }
        LOG.info((Object)"Parse Completed");
        return (ASTNode)r.getTree();
    }

    static {
        xlateMap.put("KW_TRUE", "TRUE");
        xlateMap.put("KW_FALSE", "FALSE");
        xlateMap.put("KW_ALL", "ALL");
        xlateMap.put("KW_AND", "AND");
        xlateMap.put("KW_OR", "OR");
        xlateMap.put("KW_NOT", "NOT");
        xlateMap.put("KW_LIKE", "LIKE");
        xlateMap.put("KW_ASC", "ASC");
        xlateMap.put("KW_DESC", "DESC");
        xlateMap.put("KW_ORDER", "ORDER");
        xlateMap.put("KW_BY", "BY");
        xlateMap.put("KW_GROUP", "GROUP");
        xlateMap.put("KW_WHERE", "WHERE");
        xlateMap.put("KW_FROM", "FROM");
        xlateMap.put("KW_AS", "AS");
        xlateMap.put("KW_SELECT", "SELECT");
        xlateMap.put("KW_DISTINCT", "DISTINCT");
        xlateMap.put("KW_INSERT", "INSERT");
        xlateMap.put("KW_OVERWRITE", "OVERWRITE");
        xlateMap.put("KW_OUTER", "OUTER");
        xlateMap.put("KW_JOIN", "JOIN");
        xlateMap.put("KW_LEFT", "LEFT");
        xlateMap.put("KW_RIGHT", "RIGHT");
        xlateMap.put("KW_FULL", "FULL");
        xlateMap.put("KW_ON", "ON");
        xlateMap.put("KW_PARTITION", "PARTITION");
        xlateMap.put("KW_PARTITIONS", "PARTITIONS");
        xlateMap.put("KW_TABLE", "TABLE");
        xlateMap.put("KW_TABLES", "TABLES");
        xlateMap.put("KW_SHOW", "SHOW");
        xlateMap.put("KW_MSCK", "MSCK");
        xlateMap.put("KW_DIRECTORY", "DIRECTORY");
        xlateMap.put("KW_LOCAL", "LOCAL");
        xlateMap.put("KW_TRANSFORM", "TRANSFORM");
        xlateMap.put("KW_USING", "USING");
        xlateMap.put("KW_CLUSTER", "CLUSTER");
        xlateMap.put("KW_DISTRIBUTE", "DISTRIBUTE");
        xlateMap.put("KW_SORT", "SORT");
        xlateMap.put("KW_UNION", "UNION");
        xlateMap.put("KW_LOAD", "LOAD");
        xlateMap.put("KW_DATA", "DATA");
        xlateMap.put("KW_INPATH", "INPATH");
        xlateMap.put("KW_IS", "IS");
        xlateMap.put("KW_NULL", "NULL");
        xlateMap.put("KW_CREATE", "CREATE");
        xlateMap.put("KW_EXTERNAL", "EXTERNAL");
        xlateMap.put("KW_ALTER", "ALTER");
        xlateMap.put("KW_DESCRIBE", "DESCRIBE");
        xlateMap.put("KW_DROP", "DROP");
        xlateMap.put("KW_REANME", "REANME");
        xlateMap.put("KW_TO", "TO");
        xlateMap.put("KW_COMMENT", "COMMENT");
        xlateMap.put("KW_BOOLEAN", "BOOLEAN");
        xlateMap.put("KW_TINYINT", "TINYINT");
        xlateMap.put("KW_SMALLINT", "SMALLINT");
        xlateMap.put("KW_INT", "INT");
        xlateMap.put("KW_BIGINT", "BIGINT");
        xlateMap.put("KW_FLOAT", "FLOAT");
        xlateMap.put("KW_DOUBLE", "DOUBLE");
        xlateMap.put("KW_DATE", "DATE");
        xlateMap.put("KW_DATETIME", "DATETIME");
        xlateMap.put("KW_TIMESTAMP", "TIMESTAMP");
        xlateMap.put("KW_STRING", "STRING");
        xlateMap.put("KW_ARRAY", "ARRAY");
        xlateMap.put("KW_MAP", "MAP");
        xlateMap.put("KW_REDUCE", "REDUCE");
        xlateMap.put("KW_PARTITIONED", "PARTITIONED");
        xlateMap.put("KW_CLUSTERED", "CLUSTERED");
        xlateMap.put("KW_SORTED", "SORTED");
        xlateMap.put("KW_INTO", "INTO");
        xlateMap.put("KW_BUCKETS", "BUCKETS");
        xlateMap.put("KW_ROW", "ROW");
        xlateMap.put("KW_FORMAT", "FORMAT");
        xlateMap.put("KW_DELIMITED", "DELIMITED");
        xlateMap.put("KW_FIELDS", "FIELDS");
        xlateMap.put("KW_TERMINATED", "TERMINATED");
        xlateMap.put("KW_COLLECTION", "COLLECTION");
        xlateMap.put("KW_ITEMS", "ITEMS");
        xlateMap.put("KW_KEYS", "KEYS");
        xlateMap.put("KW_KEY_TYPE", "$KEY$");
        xlateMap.put("KW_LINES", "LINES");
        xlateMap.put("KW_STORED", "STORED");
        xlateMap.put("KW_SEQUENCEFILE", "SEQUENCEFILE");
        xlateMap.put("KW_TEXTFILE", "TEXTFILE");
        xlateMap.put("KW_INPUTFORMAT", "INPUTFORMAT");
        xlateMap.put("KW_OUTPUTFORMAT", "OUTPUTFORMAT");
        xlateMap.put("KW_LOCATION", "LOCATION");
        xlateMap.put("KW_TABLESAMPLE", "TABLESAMPLE");
        xlateMap.put("KW_BUCKET", "BUCKET");
        xlateMap.put("KW_OUT", "OUT");
        xlateMap.put("KW_OF", "OF");
        xlateMap.put("KW_CAST", "CAST");
        xlateMap.put("KW_ADD", "ADD");
        xlateMap.put("KW_REPLACE", "REPLACE");
        xlateMap.put("KW_COLUMNS", "COLUMNS");
        xlateMap.put("KW_RLIKE", "RLIKE");
        xlateMap.put("KW_REGEXP", "REGEXP");
        xlateMap.put("KW_TEMPORARY", "TEMPORARY");
        xlateMap.put("KW_FUNCTION", "FUNCTION");
        xlateMap.put("KW_EXPLAIN", "EXPLAIN");
        xlateMap.put("KW_EXTENDED", "EXTENDED");
        xlateMap.put("KW_SERDE", "SERDE");
        xlateMap.put("KW_WITH", "WITH");
        xlateMap.put("KW_SERDEPROPERTIES", "SERDEPROPERTIES");
        xlateMap.put("KW_LIMIT", "LIMIT");
        xlateMap.put("KW_SET", "SET");
        xlateMap.put("KW_PROPERTIES", "TBLPROPERTIES");
        xlateMap.put("KW_VALUE_TYPE", "$VALUE$");
        xlateMap.put("KW_ELEM_TYPE", "$ELEM$");
        xlateMap.put("DOT", ".");
        xlateMap.put("COLON", ":");
        xlateMap.put("COMMA", ",");
        xlateMap.put("SEMICOLON", ");");
        xlateMap.put("LPAREN", "(");
        xlateMap.put("RPAREN", ")");
        xlateMap.put("LSQUARE", "[");
        xlateMap.put("RSQUARE", "]");
        xlateMap.put("EQUAL", "=");
        xlateMap.put("NOTEQUAL", "<>");
        xlateMap.put("LESSTHANOREQUALTO", "<=");
        xlateMap.put("LESSTHAN", "<");
        xlateMap.put("GREATERTHANOREQUALTO", ">=");
        xlateMap.put("GREATERTHAN", ">");
        xlateMap.put("DIVIDE", "/");
        xlateMap.put("PLUS", "+");
        xlateMap.put("MINUS", "-");
        xlateMap.put("STAR", "*");
        xlateMap.put("MOD", "%");
        xlateMap.put("AMPERSAND", "&");
        xlateMap.put("TILDE", "~");
        xlateMap.put("BITWISEOR", "|");
        xlateMap.put("BITWISEXOR", "^");
        adaptor = new CommonTreeAdaptor(){

            public Object create(Token payload) {
                return new ASTNode(payload);
            }
        };
    }

    public class HiveParserX
    extends HiveParser {
        private ArrayList<ParseError> errors;

        public HiveParserX(TokenStream input) {
            super(input);
            this.errors = new ArrayList();
        }

        protected void mismatch(IntStream input, int ttype, BitSet follow) throws RecognitionException {
            throw new MismatchedTokenException(ttype, input);
        }

        public void recoverFromMismatchedSet(IntStream input, RecognitionException re, BitSet follow) throws RecognitionException {
            throw re;
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new ParseError((BaseRecognizer)this, e, tokenNames));
        }

        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = null;
            String[] xlateNames = new String[tokenNames.length];
            for (int i = 0; i < tokenNames.length; ++i) {
                xlateNames[i] = ParseDriver.xlate(tokenNames[i]);
            }
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                msg = "cannot recognize input " + this.getTokenErrorDisplay(e.token);
            } else {
                msg = super.getErrorMessage(e, xlateNames);
            }
            if (this.msgs.size() > 0) {
                msg = msg + " in " + this.msgs.peek();
            }
            return msg;
        }

        public ArrayList<ParseError> getErrors() {
            return this.errors;
        }
    }

    public class HiveLexerX
    extends HiveLexer {
        private ArrayList<ParseError> errors;

        public HiveLexerX() {
            this.errors = new ArrayList();
        }

        public HiveLexerX(CharStream input) {
            super(input);
            this.errors = new ArrayList();
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new ParseError((BaseRecognizer)this, e, tokenNames));
        }

        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = null;
            if (e instanceof NoViableAltException) {
                NoViableAltException nvae = (NoViableAltException)e;
                msg = "character " + this.getCharErrorDisplay(e.c) + " not supported here";
            } else {
                msg = super.getErrorMessage(e, tokenNames);
            }
            return msg;
        }

        public ArrayList<ParseError> getErrors() {
            return this.errors;
        }
    }

    public class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

