/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.copyWork;
import org.apache.hadoop.hive.ql.plan.loadTableDesc;
import org.apache.hadoop.hive.ql.plan.moveWork;

public class LoadSemanticAnalyzer
extends BaseSemanticAnalyzer {
    boolean isLocal;
    boolean isOverWrite;

    public LoadSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    public static FileStatus[] matchFilesOrDir(FileSystem fs, Path path) throws IOException {
        FileStatus[] srcs = fs.globStatus(path);
        if (srcs != null && srcs.length == 1 && srcs[0].isDir()) {
            srcs = fs.listStatus(srcs[0].getPath());
        }
        return srcs;
    }

    private URI initializeFromURI(String fromPath) throws IOException, URISyntaxException {
        URI defaultURI;
        URI fromURI = new Path(fromPath).toUri();
        String fromScheme = fromURI.getScheme();
        String fromAuthority = fromURI.getAuthority();
        String path = fromURI.getPath();
        if (!path.startsWith("/")) {
            path = this.isLocal ? new Path(System.getProperty("user.dir"), path).toString() : new Path(new Path("/user/" + System.getProperty("user.name")), path).toString();
        }
        if (StringUtils.isEmpty(fromScheme)) {
            if (this.isLocal) {
                fromScheme = "file";
            } else {
                defaultURI = FileSystem.get((Configuration)this.conf).getUri();
                fromScheme = defaultURI.getScheme();
                fromAuthority = defaultURI.getAuthority();
            }
        }
        if (fromScheme.equals("hdfs") && StringUtils.isEmpty(fromAuthority)) {
            defaultURI = FileSystem.get((Configuration)this.conf).getUri();
            fromAuthority = defaultURI.getAuthority();
        }
        this.LOG.debug((Object)(fromScheme + "@" + fromAuthority + "@" + path));
        return new URI(fromScheme, fromAuthority, path, null, null);
    }

    private void applyConstraints(URI fromURI, URI toURI, Tree ast, boolean isLocal) throws SemanticException {
        if (!fromURI.getScheme().equals("file") && !fromURI.getScheme().equals("hdfs")) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "only \"file\" or \"hdfs\" file systems accepted"));
        }
        if (isLocal && !fromURI.getScheme().equals("file")) {
            throw new SemanticException(ErrorMsg.ILLEGAL_PATH.getMsg(ast, "Source file system should be \"file\" if \"local\" is specified"));
        }
        try {
            FileStatus[] srcs = LoadSemanticAnalyzer.matchFilesOrDir(FileSystem.get((URI)fromURI, (Configuration)this.conf), new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath()));
            if (srcs == null || srcs.length == 0) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "No files matching path " + fromURI));
            }
            for (FileStatus oneSrc : srcs) {
                if (!oneSrc.isDir()) continue;
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "source contains directory: " + oneSrc.getPath().toString()));
            }
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast), e);
        }
        if (!(isLocal || StringUtils.equals(fromURI.getScheme(), toURI.getScheme()) && StringUtils.equals(fromURI.getAuthority(), toURI.getAuthority()))) {
            String reason = "Move from: " + fromURI.toString() + " to: " + toURI.toString() + " is not valid. " + "Please check that values for params \"default.fs.name\" and " + "\"hive.metastore.warehouse.dir\" do not conflict.";
            throw new SemanticException(ErrorMsg.ILLEGAL_PATH.getMsg(ast, reason));
        }
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        URI fromURI;
        this.isOverWrite = false;
        this.isLocal = false;
        Tree from_t = ast.getChild(0);
        Tree table_t = ast.getChild(1);
        if (ast.getChildCount() == 4) {
            this.isLocal = true;
            this.isOverWrite = true;
        }
        if (ast.getChildCount() == 3) {
            if (ast.getChild(2).getText().toLowerCase().equals("local")) {
                this.isLocal = true;
            } else {
                this.isOverWrite = true;
            }
        }
        try {
            String fromPath = LoadSemanticAnalyzer.stripQuotes(from_t.getText());
            fromURI = this.initializeFromURI(fromPath);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(from_t, e.getMessage()), e);
        }
        catch (URISyntaxException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(from_t, e.getMessage()), e);
        }
        BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, (ASTNode)table_t);
        URI toURI = ts.partHandle != null ? ts.partHandle.getDataLocation() : ts.tableHandle.getDataLocation();
        List parts = ts.tableHandle.getTTable().getPartitionKeys();
        if (this.isOverWrite && parts != null && parts.size() > 0 && (ts.partSpec == null || ts.partSpec.size() == 0)) {
            throw new SemanticException(ErrorMsg.NEED_PARTITION_ERROR.getMsg());
        }
        this.applyConstraints(fromURI, toURI, from_t, this.isLocal);
        Task<Serializable> rTask = null;
        if (this.isLocal) {
            String copyURIStr = this.ctx.getExternalTmpFileURI(toURI);
            URI copyURI = URI.create(copyURIStr);
            rTask = TaskFactory.get(new copyWork(fromURI.toString(), copyURIStr), this.conf, new Task[0]);
            fromURI = copyURI;
        }
        String loadTmpPath = this.ctx.getExternalTmpFileURI(toURI);
        loadTableDesc loadTableWork = new loadTableDesc(fromURI.toString(), loadTmpPath, Utilities.getTableDesc(ts.tableHandle), ts.partSpec != null ? ts.partSpec : new HashMap<String, String>(), this.isOverWrite);
        if (rTask != null) {
            rTask.addDependentTask(TaskFactory.get(new moveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true), this.conf, new Task[0]));
        } else {
            rTask = TaskFactory.get(new moveWork(this.getInputs(), this.getOutputs(), loadTableWork, null, true), this.conf, new Task[0]);
        }
        this.rootTasks.add(rTask);
    }
}

