/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.createFunctionDesc;
import org.apache.hadoop.hive.ql.plan.dropFunctionDesc;

public class FunctionSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.FunctionSemanticAnalyzer");

    public FunctionSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 123) {
            this.analyzeCreateFunction(ast);
        }
        if (ast.getToken().getType() == 124) {
            this.analyzeDropFunction(ast);
        }
        LOG.info((Object)"analyze done");
    }

    private void analyzeCreateFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        String className = FunctionSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        createFunctionDesc desc = new createFunctionDesc(functionName, className);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
    }

    private void analyzeDropFunction(ASTNode ast) throws SemanticException {
        String functionName = ast.getChild(0).getText();
        dropFunctionDesc desc = new dropFunctionDesc(functionName);
        this.rootTasks.add(TaskFactory.get(new FunctionWork(desc), this.conf, new Task[0]));
    }
}

