/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.unionproc;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;

public class UnionProcContext
implements NodeProcessorCtx {
    private boolean mapOnlySubq = true;
    private Map<UnionOperator, UnionParseContext> uCtxMap = new HashMap<UnionOperator, UnionParseContext>();

    public boolean isMapOnlySubq() {
        return this.mapOnlySubq;
    }

    public void setMapOnlySubq(boolean mapOnlySubq) {
        this.mapOnlySubq = mapOnlySubq;
    }

    public void setUnionParseContext(UnionOperator u, UnionParseContext uCtx) {
        this.uCtxMap.put(u, uCtx);
    }

    public UnionParseContext getUnionParseContext(UnionOperator u) {
        return this.uCtxMap.get(u);
    }

    public static class UnionParseContext {
        private transient boolean[] mapOnlySubq;
        private transient boolean[] rootTask;
        private transient boolean[] mapJoinSubq;
        private transient int numInputs;
        private transient boolean mapJoinQuery;

        public UnionParseContext(int numInputs) {
            this.numInputs = numInputs;
            this.mapOnlySubq = new boolean[numInputs];
            this.rootTask = new boolean[numInputs];
            this.mapJoinSubq = new boolean[numInputs];
        }

        public boolean getMapOnlySubq(int pos) {
            return this.mapOnlySubq[pos];
        }

        public void setMapOnlySubq(int pos, boolean mapOnlySubq) {
            this.mapOnlySubq[pos] = mapOnlySubq;
        }

        public boolean getMapJoinSubq(int pos) {
            return this.mapJoinSubq[pos];
        }

        public void setMapJoinSubq(int pos, boolean mapJoinSubq) {
            this.mapJoinSubq[pos] = mapJoinSubq;
            if (mapJoinSubq) {
                this.mapJoinQuery = true;
            }
        }

        public boolean getMapJoinQuery() {
            return this.mapJoinQuery;
        }

        public boolean getRootTask(int pos) {
            return this.rootTask[pos];
        }

        public void setRootTask(int pos, boolean rootTask) {
            this.rootTask[pos] = rootTask;
        }

        public int getNumInputs() {
            return this.numInputs;
        }

        public void setNumInputs(int numInputs) {
            this.numInputs = numInputs;
        }
    }
}

