/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.selectDesc;

public class ColumnPrunerProcCtx
implements NodeProcessorCtx {
    private Map<Operator<? extends Serializable>, List<String>> prunedColLists = new HashMap<Operator<? extends Serializable>, List<String>>();
    private HashMap<Operator<? extends Serializable>, OpParseContext> opToParseCtxMap;
    private Map<CommonJoinOperator, Map<Byte, List<String>>> joinPrunedColLists;

    public ColumnPrunerProcCtx(HashMap<Operator<? extends Serializable>, OpParseContext> opToParseContextMap) {
        this.opToParseCtxMap = opToParseContextMap;
        this.joinPrunedColLists = new HashMap<CommonJoinOperator, Map<Byte, List<String>>>();
    }

    public Map<CommonJoinOperator, Map<Byte, List<String>>> getJoinPrunedColLists() {
        return this.joinPrunedColLists;
    }

    public List<String> getPrunedColList(Operator<? extends Serializable> op) {
        return this.prunedColLists.get(op);
    }

    public HashMap<Operator<? extends Serializable>, OpParseContext> getOpToParseCtxMap() {
        return this.opToParseCtxMap;
    }

    public Map<Operator<? extends Serializable>, List<String>> getPrunedColLists() {
        return this.prunedColLists;
    }

    public List<String> genColLists(Operator<? extends Serializable> curOp) throws SemanticException {
        List<String> colList = new ArrayList<String>();
        if (curOp.getChildOperators() != null) {
            for (Operator<Serializable> child : curOp.getChildOperators()) {
                if (child instanceof CommonJoinOperator) {
                    int tag = child.getParentOperators().indexOf(curOp);
                    List<String> prunList = this.joinPrunedColLists.get((CommonJoinOperator)child).get((byte)tag);
                    colList = Utilities.mergeUniqElems(colList, prunList);
                    continue;
                }
                colList = Utilities.mergeUniqElems(colList, this.prunedColLists.get(child));
            }
        }
        return colList;
    }

    public List<String> getColsFromSelectExpr(SelectOperator op) {
        List<String> cols = new ArrayList<String>();
        selectDesc conf = (selectDesc)op.getConf();
        ArrayList<exprNodeDesc> exprList = conf.getColList();
        for (exprNodeDesc expr : exprList) {
            cols = Utilities.mergeUniqElems(cols, expr.getCols());
        }
        return cols;
    }

    public List<String> getSelectColsFromChildren(SelectOperator op, List<String> colList) {
        List<String> cols = new ArrayList<String>();
        selectDesc conf = (selectDesc)op.getConf();
        if (conf.isSelStarNoCompute()) {
            cols.addAll(colList);
            return cols;
        }
        ArrayList<exprNodeDesc> selectExprs = conf.getColList();
        ArrayList<String> outputColumnNames = conf.getOutputColumnNames();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            if (!colList.contains(outputColumnNames.get(i))) continue;
            exprNodeDesc expr = selectExprs.get(i);
            cols = Utilities.mergeUniqElems(cols, expr.getCols());
        }
        return cols;
    }
}

