/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class CombineHiveRecordReader<K extends WritableComparable, V extends Writable>
implements RecordReader<K, V> {
    private RecordReader recordReader;

    public CombineHiveRecordReader(InputSplit split, Configuration conf, Reporter reporter, Integer partition) throws IOException {
        JobConf job = (JobConf)conf;
        CombineHiveInputFormat.CombineHiveInputSplit hsplit = new CombineHiveInputFormat.CombineHiveInputSplit(job, (HadoopShims.InputSplitShim)split);
        String inputFormatClassName = hsplit.inputFormatClassName();
        Class<?> inputFormatClass = null;
        try {
            inputFormatClass = Class.forName(inputFormatClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("CombineHiveRecordReader: class not found " + inputFormatClassName);
        }
        InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
        FileSplit fsplit = new FileSplit(hsplit.getPaths()[partition], hsplit.getStartOffsets()[partition], hsplit.getLengths()[partition], hsplit.getLocations());
        this.recordReader = inputFormat.getRecordReader((InputSplit)fsplit, job, reporter);
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    public K createKey() {
        return (K)((WritableComparable)this.recordReader.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.recordReader.createValue());
    }

    public long getPos() throws IOException {
        return this.recordReader.getPos();
    }

    public float getProgress() throws IOException {
        return this.recordReader.getProgress();
    }

    public boolean next(K key, V value) throws IOException {
        if (ExecMapper.getDone()) {
            return false;
        }
        return this.recordReader.next(key, value);
    }
}

