/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ReadEntity {
    private Partition p;
    private Table t;

    public ReadEntity(Table t) {
        this.t = t;
        this.p = null;
    }

    public ReadEntity(Partition p) {
        this.t = p.getTable();
        this.p = p;
    }

    public Type getType() {
        return this.p == null ? Type.TABLE : Type.PARTITION;
    }

    public Map<String, String> getParameters() {
        if (this.p != null) {
            return this.p.getTPartition().getParameters();
        }
        return this.t.getTTable().getParameters();
    }

    public URI getLocation() {
        if (this.p != null) {
            return this.p.getDataLocation();
        }
        return this.t.getDataLocation();
    }

    public Partition getPartition() {
        return this.p;
    }

    public Table getTable() {
        return this.t;
    }

    public String toString() {
        if (this.p != null) {
            return this.p.getTable().getDbName() + "@" + this.p.getTable().getName() + "@" + this.p.getName();
        }
        return this.t.getDbName() + "@" + this.t.getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ReadEntity) {
            ReadEntity ore = (ReadEntity)o;
            return this.toString().equalsIgnoreCase(ore.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum Type {
        TABLE,
        PARTITION;

    }
}

