/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.limitDesc;

public class LimitOperator
extends Operator<limitDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient int limit;
    protected transient int currCount;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.limit = ((limitDesc)this.conf).getLimit();
        this.currCount = 0;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.currCount < this.limit) {
            this.forward(row, this.inputObjInspectors[tag]);
            ++this.currCount;
        } else {
            this.setDone(true);
        }
    }

    @Override
    public String getName() {
        return "LIM";
    }

    @Override
    public int getType() {
        return 6;
    }
}

