/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.filterDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class FilterOperator
extends Operator<filterDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable filtered_count = new LongWritable();
    private final transient LongWritable passed_count = new LongWritable();
    private transient ExprNodeEvaluator conditionEvaluator;
    private transient PrimitiveObjectInspector conditionInspector;
    private transient int consecutiveFails = 0;
    transient int heartbeatInterval;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
            this.conditionEvaluator = ExprNodeEvaluatorFactory.get(((filterDesc)this.conf).getPredicate());
            this.statsMap.put(Counter.FILTERED, this.filtered_count);
            this.statsMap.put(Counter.PASSED, this.passed_count);
            this.conditionInspector = null;
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        this.initializeChildren(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        Object condition;
        Boolean ret;
        ObjectInspector rowInspector = this.inputObjInspectors[tag];
        if (this.conditionInspector == null) {
            this.conditionInspector = (PrimitiveObjectInspector)this.conditionEvaluator.initialize(rowInspector);
        }
        if (Boolean.TRUE.equals(ret = (Boolean)this.conditionInspector.getPrimitiveJavaObject(condition = this.conditionEvaluator.evaluate(row)))) {
            this.forward(row, rowInspector);
            this.passed_count.set(this.passed_count.get() + 1L);
            this.consecutiveFails = 0;
        } else {
            this.filtered_count.set(this.filtered_count.get() + 1L);
            ++this.consecutiveFails;
            if (this.consecutiveFails % this.heartbeatInterval == 0 && this.reporter != null) {
                this.reporter.progress();
            }
        }
    }

    @Override
    public String getName() {
        return new String("FIL");
    }

    @Override
    public int getType() {
        return 3;
    }

    public static enum Counter {
        FILTERED,
        PASSED;

    }
}

