/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.Graph;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.plan.api.Stage;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.transport.TMemoryBuffer;

public class QueryPlan
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)QueryPlan.class.getName());
    private String queryString;
    private BaseSemanticAnalyzer plan;
    private String queryId;
    private Query query;
    private Map<String, Map<String, Long>> counters;
    private Set<String> done;
    private Set<String> started;
    private boolean add;

    public QueryPlan(String queryString, BaseSemanticAnalyzer plan) {
        this.queryString = queryString;
        this.plan = plan;
        this.queryId = this.makeQueryId();
        this.query = new Query();
        this.query.setQueryId(this.queryId);
        this.query.putToQueryAttributes("queryString", this.queryString);
        this.counters = new HashMap<String, Map<String, Long>>();
        this.done = new HashSet<String>();
        this.started = new HashSet<String>();
    }

    public String getQueryStr() {
        return this.queryString;
    }

    public BaseSemanticAnalyzer getPlan() {
        return this.plan;
    }

    public String getQueryId() {
        return this.queryId;
    }

    private String makeQueryId() {
        GregorianCalendar gc = new GregorianCalendar();
        String userid = System.getProperty("user.name");
        return userid + "_" + String.format("%1$4d%2$02d%3$02d%4$02d%5$02d%5$02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12), gc.get(13));
    }

    private void populateOperatorGraph(org.apache.hadoop.hive.ql.plan.api.Task task, Collection<Operator<? extends Serializable>> topOps) {
        task.setOperatorGraph(new Graph());
        task.getOperatorGraph().setNodeType(0);
        LinkedList<Operator<? extends Serializable>> opsToVisit = new LinkedList<Operator<? extends Serializable>>();
        HashSet<Operator> opsVisited = new HashSet<Operator>();
        opsToVisit.addAll(topOps);
        while (opsToVisit.peek() != null) {
            Operator op = (Operator)opsToVisit.remove();
            opsVisited.add(op);
            org.apache.hadoop.hive.ql.plan.api.Operator operator = new org.apache.hadoop.hive.ql.plan.api.Operator();
            operator.setOperatorId(op.getOperatorId());
            operator.setOperatorType(op.getType());
            task.addToOperatorList(operator);
            if (op.getChildOperators() == null) continue;
            Adjacency entry = new Adjacency();
            entry.setAdjacencyType(0);
            entry.setNode(op.getOperatorId());
            for (Operator<Serializable> childOp : op.getChildOperators()) {
                entry.addToChildren(childOp.getOperatorId());
                if (opsVisited.contains(childOp)) continue;
                opsToVisit.add(childOp);
            }
            task.getOperatorGraph().addToAdjacencyList(entry);
        }
    }

    private void populateQueryPlan() throws IOException {
        this.query.setStageGraph(new Graph());
        this.query.getStageGraph().setNodeType(1);
        LinkedList<Task<? extends Serializable>> tasksToVisit = new LinkedList<Task<? extends Serializable>>();
        HashSet<Task> tasksVisited = new HashSet<Task>();
        tasksToVisit.addAll(this.plan.getRootTasks());
        while (tasksToVisit.size() != 0) {
            Task task = (Task)tasksToVisit.remove();
            tasksVisited.add(task);
            Stage stage = new Stage();
            stage.setStageId(task.getId());
            stage.setStageType(task.getType());
            this.query.addToStageList(stage);
            if (task instanceof ExecDriver) {
                ExecDriver mrTask = (ExecDriver)task;
                org.apache.hadoop.hive.ql.plan.api.Task mapTask = new org.apache.hadoop.hive.ql.plan.api.Task();
                mapTask.setTaskId(stage.getStageId() + "_MAP");
                mapTask.setTaskType(0);
                stage.addToTaskList(mapTask);
                this.populateOperatorGraph(mapTask, ((mapredWork)mrTask.getWork()).getAliasToWork().values());
                if (mrTask.hasReduce()) {
                    org.apache.hadoop.hive.ql.plan.api.Task reduceTask = new org.apache.hadoop.hive.ql.plan.api.Task();
                    reduceTask.setTaskId(stage.getStageId() + "_REDUCE");
                    reduceTask.setTaskType(1);
                    stage.addToTaskList(reduceTask);
                    ArrayList<Operator<? extends Serializable>> reducerTopOps = new ArrayList<Operator<? extends Serializable>>();
                    reducerTopOps.add(((mapredWork)mrTask.getWork()).getReducer());
                    this.populateOperatorGraph(reduceTask, reducerTopOps);
                }
            } else {
                org.apache.hadoop.hive.ql.plan.api.Task otherTask = new org.apache.hadoop.hive.ql.plan.api.Task();
                otherTask.setTaskId(stage.getStageId() + "_OTHER");
                otherTask.setTaskType(2);
                stage.addToTaskList(otherTask);
            }
            if (task instanceof ConditionalTask) {
                Adjacency listEntry = new Adjacency();
                listEntry.setAdjacencyType(1);
                listEntry.setNode(task.getId());
                ConditionalTask t = (ConditionalTask)task;
                for (Task<? extends Serializable> listTask : t.getListTasks()) {
                    if (t.getChildTasks() != null) {
                        Adjacency childEntry = new Adjacency();
                        childEntry.setAdjacencyType(1);
                        childEntry.setNode(listTask.getId());
                        for (Task<Serializable> childTask : t.getChildTasks()) {
                            childEntry.addToChildren(childTask.getId());
                            if (tasksVisited.contains(childTask)) continue;
                            tasksToVisit.add(childTask);
                        }
                        this.query.getStageGraph().addToAdjacencyList(childEntry);
                    }
                    listEntry.addToChildren(listTask.getId());
                    if (tasksVisited.contains(listTask)) continue;
                    tasksToVisit.add(listTask);
                }
                this.query.getStageGraph().addToAdjacencyList(listEntry);
                continue;
            }
            if (task.getChildTasks() == null) continue;
            Adjacency entry = new Adjacency();
            entry.setAdjacencyType(0);
            entry.setNode(task.getId());
            for (Task<Serializable> childTask : task.getChildTasks()) {
                entry.addToChildren(childTask.getId());
                if (tasksVisited.contains(childTask)) continue;
                tasksToVisit.add(childTask);
            }
            this.query.getStageGraph().addToAdjacencyList(entry);
        }
    }

    private void updateCountersInQueryPlan() {
        this.query.setStarted(this.started.contains(this.query.getQueryId()));
        this.query.setDone(this.done.contains(this.query.getQueryId()));
        if (this.query.getStageList() != null) {
            for (Stage stage : this.query.getStageList()) {
                stage.setStarted(this.started.contains(stage.getStageId()));
                stage.setStageCounters(this.counters.get(stage.getStageId()));
                stage.setDone(this.done.contains(stage.getStageId()));
                for (org.apache.hadoop.hive.ql.plan.api.Task task : stage.getTaskList()) {
                    task.setTaskCounters(this.counters.get(task.getTaskId()));
                    if (task.getTaskType() == 2) {
                        task.setStarted(this.started.contains(stage.getStageId()));
                        task.setDone(this.done.contains(stage.getStageId()));
                        continue;
                    }
                    task.setStarted(this.started.contains(task.getTaskId()));
                    task.setDone(this.done.contains(task.getTaskId()));
                    for (org.apache.hadoop.hive.ql.plan.api.Operator op : task.getOperatorList()) {
                        op.setStarted(this.started.contains(task.getTaskId()));
                        op.setOperatorCounters(this.counters.get(op.getOperatorId()));
                        op.setDone(this.done.contains(task.getTaskId()));
                    }
                }
            }
        }
    }

    private void extractCounters() throws IOException {
        LinkedList<Task<? extends Serializable>> tasksToVisit = new LinkedList<Task<? extends Serializable>>();
        HashSet<Task> tasksVisited = new HashSet<Task>();
        tasksToVisit.addAll(this.plan.getRootTasks());
        while (tasksToVisit.peek() != null) {
            Task task = (Task)tasksToVisit.remove();
            tasksVisited.add(task);
            if (task.getChildTasks() != null) {
                for (Task<Serializable> childTask : task.getChildTasks()) {
                    if (tasksVisited.contains(childTask)) continue;
                    tasksToVisit.add(childTask);
                }
            }
            if (this.started.contains(task.getId()) && this.done.contains(task.getId())) continue;
            this.counters.put(task.getId(), task.getCounters());
            if (task.started()) {
                this.started.add(task.getId());
            }
            if (task.done()) {
                this.done.add(task.getId());
            }
            if (task instanceof ExecDriver) {
                ExecDriver mrTask = (ExecDriver)task;
                this.extractOperatorCounters(((mapredWork)mrTask.getWork()).getAliasToWork().values(), task.getId() + "_MAP");
                if (mrTask.mapStarted()) {
                    this.started.add(task.getId() + "_MAP");
                }
                if (mrTask.mapDone()) {
                    this.done.add(task.getId() + "_MAP");
                }
                if (!mrTask.hasReduce()) continue;
                ArrayList<Operator<? extends Serializable>> reducerTopOps = new ArrayList<Operator<? extends Serializable>>();
                reducerTopOps.add(((mapredWork)mrTask.getWork()).getReducer());
                this.extractOperatorCounters(reducerTopOps, task.getId() + "_REDUCE");
                if (mrTask.reduceStarted()) {
                    this.started.add(task.getId() + "_REDUCE");
                }
                if (!mrTask.reduceDone()) continue;
                this.done.add(task.getId() + "_REDUCE");
                continue;
            }
            if (!(task instanceof ConditionalTask)) continue;
            ConditionalTask cTask = (ConditionalTask)task;
            for (Task<? extends Serializable> listTask : cTask.getListTasks()) {
                if (tasksVisited.contains(listTask)) continue;
                tasksToVisit.add(listTask);
            }
        }
    }

    private void extractOperatorCounters(Collection<Operator<? extends Serializable>> topOps, String taskId) {
        LinkedList<Operator<? extends Serializable>> opsToVisit = new LinkedList<Operator<? extends Serializable>>();
        HashSet<Operator> opsVisited = new HashSet<Operator>();
        opsToVisit.addAll(topOps);
        while (opsToVisit.size() != 0) {
            Operator op = (Operator)opsToVisit.remove();
            opsVisited.add(op);
            this.counters.put(op.getOperatorId(), op.getCounters());
            if (op.getDone()) {
                this.done.add(op.getOperatorId());
            }
            if (op.getChildOperators() == null) continue;
            for (Operator<Serializable> childOp : op.getChildOperators()) {
                if (opsVisited.contains(childOp)) continue;
                opsToVisit.add(childOp);
            }
        }
    }

    public Query getQueryPlan() throws IOException {
        if (this.query.getStageGraph() == null) {
            this.populateQueryPlan();
        }
        this.extractCounters();
        this.updateCountersInQueryPlan();
        return this.query;
    }

    public String getJSONValue(Object value) {
        String v = "null";
        if (value != null && (v = value.toString()).charAt(0) != '[' && v.charAt(0) != '{') {
            v = "\"" + v + "\"";
        }
        return v;
    }

    public String getJSONKeyValue(Object key, Object value) {
        return "\"" + key + "\":" + this.getJSONValue(value) + ",";
    }

    private String getJSONList(List list) {
        if (list == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object entry : list) {
            sb.append(this.getJSONValue(entry));
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public String getJSONMap(Map map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry;
            Map.Entry e = entry = i$.next();
            sb.append(this.getJSONKeyValue(e.getKey(), e.getValue()));
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private Object getJSONGraph(Graph graph) {
        if (graph == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("nodeType", graph.getNodeType()));
        sb.append(this.getJSONKeyValue("roots", this.getJSONList(graph.getRoots())));
        ArrayList<String> adjList = new ArrayList<String>();
        if (graph.getAdjacencyList() != null) {
            for (Adjacency adj : graph.getAdjacencyList()) {
                adjList.add(this.getJSONAdjacency(adj));
            }
        }
        sb.append(this.getJSONKeyValue("adjacencyList", this.getJSONList(adjList)));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private String getJSONAdjacency(Adjacency adj) {
        if (adj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("node", adj.getNode()));
        sb.append(this.getJSONKeyValue("children", this.getJSONList(adj.getChildren())));
        sb.append(this.getJSONKeyValue("adjacencyType", adj.getAdjacencyType()));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private String getJSONOperator(org.apache.hadoop.hive.ql.plan.api.Operator op) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("operatorId", op.getOperatorId()));
        sb.append(this.getJSONKeyValue("operatorType", op.getOperatorType()));
        sb.append(this.getJSONKeyValue("operatorAttributes", this.getJSONMap(op.getOperatorAttributes())));
        sb.append(this.getJSONKeyValue("operatorCounters", this.getJSONMap(op.getOperatorCounters())));
        sb.append(this.getJSONKeyValue("done", op.isDone()));
        sb.append(this.getJSONKeyValue("started", op.isStarted()));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private String getJSONTask(org.apache.hadoop.hive.ql.plan.api.Task task) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("taskId", task.getTaskId()));
        sb.append(this.getJSONKeyValue("taskType", task.getTaskType()));
        sb.append(this.getJSONKeyValue("taskAttributes", this.getJSONMap(task.getTaskAttributes())));
        sb.append(this.getJSONKeyValue("taskCounters", this.getJSONMap(task.getTaskCounters())));
        sb.append(this.getJSONKeyValue("operatorGraph", this.getJSONGraph(task.getOperatorGraph())));
        ArrayList<String> opList = new ArrayList<String>();
        if (task.getOperatorList() != null) {
            for (org.apache.hadoop.hive.ql.plan.api.Operator op : task.getOperatorList()) {
                opList.add(this.getJSONOperator(op));
            }
        }
        sb.append(this.getJSONKeyValue("operatorList", this.getJSONList(opList)));
        sb.append(this.getJSONKeyValue("done", task.isDone()));
        sb.append(this.getJSONKeyValue("started", task.isStarted()));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private String getJSONStage(Stage stage) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("stageId", stage.getStageId()));
        sb.append(this.getJSONKeyValue("stageType", stage.getStageType()));
        sb.append(this.getJSONKeyValue("stageAttributes", this.getJSONMap(stage.getStageAttributes())));
        sb.append(this.getJSONKeyValue("stageCounters", this.getJSONMap(stage.getStageCounters())));
        ArrayList<String> taskList = new ArrayList<String>();
        if (stage.getTaskList() != null) {
            for (org.apache.hadoop.hive.ql.plan.api.Task task : stage.getTaskList()) {
                taskList.add(this.getJSONTask(task));
            }
        }
        sb.append(this.getJSONKeyValue("taskList", this.getJSONList(taskList)));
        sb.append(this.getJSONKeyValue("done", stage.isDone()));
        sb.append(this.getJSONKeyValue("started", stage.isStarted()));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String getJSONQuery(Query query) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.getJSONKeyValue("queryId", query.getQueryId()));
        sb.append(this.getJSONKeyValue("queryType", query.getQueryType()));
        sb.append(this.getJSONKeyValue("queryAttributes", this.getJSONMap(query.getQueryAttributes())));
        sb.append(this.getJSONKeyValue("queryCounters", this.getJSONMap(query.getQueryCounters())));
        sb.append(this.getJSONKeyValue("stageGraph", this.getJSONGraph(query.getStageGraph())));
        ArrayList<String> stageList = new ArrayList<String>();
        if (query.getStageList() != null) {
            for (Stage stage : query.getStageList()) {
                stageList.add(this.getJSONStage(stage));
            }
        }
        sb.append(this.getJSONKeyValue("stageList", this.getJSONList(stageList)));
        sb.append(this.getJSONKeyValue("done", query.isDone()));
        sb.append(this.getJSONKeyValue("started", query.isStarted()));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        try {
            return this.getJSONQuery(this.getQueryPlan());
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public String toThriftJSONString() throws IOException {
        Query q = this.getQueryPlan();
        TMemoryBuffer tmb = new TMemoryBuffer(q.toString().length() * 5);
        TJSONProtocol oprot = new TJSONProtocol(tmb);
        try {
            q.write(oprot);
        }
        catch (TException e) {
            e.printStackTrace();
            return q.toString();
        }
        return tmb.toString("UTF-8");
    }

    public String toBinaryString() throws IOException {
        Query q = this.getQueryPlan();
        TMemoryBuffer tmb = new TMemoryBuffer(q.toString().length() * 5);
        TBinaryProtocol oprot = new TBinaryProtocol(tmb);
        try {
            q.write(oprot);
        }
        catch (TException e) {
            e.printStackTrace();
            return q.toString();
        }
        byte[] buf = new byte[tmb.length()];
        tmb.read(buf, 0, tmb.length());
        return new String(buf);
    }

    public void setStarted() {
        this.started.add(this.queryId);
    }

    public void setDone() {
        this.done.add(this.queryId);
    }

    public Set<String> getStarted() {
        return this.started;
    }

    public Set<String> getDone() {
        return this.done;
    }
}

