/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;

public class Context {
    private Path resFile;
    private Path resDir;
    private FileSystem resFs;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.Context");
    private Path[] resDirPaths;
    private int resDirFilesNum;
    boolean initialized;
    private String scratchPath;
    private Path MRScratchDir;
    private Path localScratchDir;
    private ArrayList<Path> allScratchDirs = new ArrayList();
    private HiveConf conf;
    Random rand = new Random();
    protected int randomid = Math.abs(this.rand.nextInt());
    protected int pathid = 10000;
    protected boolean explain = false;

    public Context() {
    }

    public Context(HiveConf conf) {
        this.conf = conf;
        Path tmpPath = new Path(conf.getVar(HiveConf.ConfVars.SCRATCHDIR));
        this.scratchPath = tmpPath.toUri().getPath();
    }

    public void setExplain(boolean value) {
        this.explain = value;
    }

    public boolean getExplain() {
        return this.explain;
    }

    private void makeLocalScratchDir() throws IOException {
        LocalFileSystem fs;
        do {
            this.localScratchDir = new Path(System.getProperty("java.io.tmpdir") + File.separator + Math.abs(this.rand.nextInt()));
        } while (!(fs = FileSystem.getLocal((Configuration)this.conf)).mkdirs(this.localScratchDir));
        this.localScratchDir = fs.makeQualified(this.localScratchDir);
        this.allScratchDirs.add(this.localScratchDir);
    }

    private void makeMRScratchDir() throws IOException {
        FileSystem fs;
        do {
            this.MRScratchDir = FileUtils.makeQualified(new Path(this.conf.getVar(HiveConf.ConfVars.SCRATCHDIR), Integer.toString(Math.abs(this.rand.nextInt()))), this.conf);
            if (!this.explain) continue;
            this.allScratchDirs.add(this.MRScratchDir);
            return;
        } while (!(fs = this.MRScratchDir.getFileSystem((Configuration)this.conf)).mkdirs(this.MRScratchDir));
        this.allScratchDirs.add(this.MRScratchDir);
    }

    private Path makeExternalScratchDir(URI extURI) throws IOException {
        Path extScratchDir;
        FileSystem fs;
        do {
            String extPath = this.scratchPath + File.separator + Integer.toString(Math.abs(this.rand.nextInt()));
            extScratchDir = new Path(extURI.getScheme(), extURI.getAuthority(), extPath);
            if (!this.explain) continue;
            this.allScratchDirs.add(extScratchDir);
            return extScratchDir;
        } while (!(fs = extScratchDir.getFileSystem((Configuration)this.conf)).mkdirs(extScratchDir));
        this.allScratchDirs.add(extScratchDir);
        return extScratchDir;
    }

    private String getExternalScratchDir(URI extURI) {
        try {
            for (Path p : this.allScratchDirs) {
                URI pURI = p.toUri();
                if (!Context.strEquals(pURI.getScheme(), extURI.getScheme()) || !Context.strEquals(pURI.getAuthority(), extURI.getAuthority())) continue;
                return p.toString();
            }
            return this.makeExternalScratchDir(extURI).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getMRScratchDir() {
        if (this.MRScratchDir == null) {
            try {
                this.makeMRScratchDir();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Error while making MR scratch directory - check filesystem config (" + e.getCause() + ")", e);
            }
        }
        return this.MRScratchDir.toString();
    }

    private String getLocalScratchDir() {
        if (this.localScratchDir == null) {
            try {
                this.makeLocalScratchDir();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Error while making local scratch directory - check filesystem config (" + e.getCause() + ")", e);
            }
        }
        return this.localScratchDir.toString();
    }

    private void removeScratchDir() {
        if (this.explain) {
            try {
                if (this.localScratchDir != null) {
                    FileSystem.getLocal((Configuration)this.conf).delete(this.localScratchDir, true);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Error Removing Scratch: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        } else {
            for (Path p : this.allScratchDirs) {
                try {
                    p.getFileSystem((Configuration)this.conf).delete(p, true);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error Removing Scratch: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                }
            }
        }
        this.MRScratchDir = null;
        this.localScratchDir = null;
    }

    private String nextPath(String base) {
        return base + File.separator + Integer.toString(this.pathid++);
    }

    public boolean isMRTmpFileURI(String uriStr) {
        return uriStr.indexOf(this.scratchPath) != -1;
    }

    public String getMRTmpFileURI() {
        return this.nextPath(this.getMRScratchDir());
    }

    public String getLocalTmpFileURI() {
        return this.nextPath(this.getLocalScratchDir());
    }

    public String getExternalTmpFileURI(URI extURI) {
        return this.nextPath(this.getExternalScratchDir(extURI));
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
        this.resDir = null;
        this.resDirPaths = null;
        this.resDirFilesNum = 0;
    }

    public Path getResDir() {
        return this.resDir;
    }

    public void setResDir(Path resDir) {
        this.resDir = resDir;
        this.resFile = null;
        this.resDirFilesNum = 0;
        this.resDirPaths = null;
    }

    public void clear() throws IOException {
        FileSystem fs;
        if (this.resDir != null) {
            try {
                fs = this.resDir.getFileSystem((Configuration)this.conf);
                fs.delete(this.resDir, true);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        if (this.resFile != null) {
            try {
                fs = this.resFile.getFileSystem((Configuration)this.conf);
                fs.delete(this.resFile, false);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.removeScratchDir();
    }

    public DataInput getStream() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                if (this.resFile == null && this.resDir == null) {
                    return null;
                }
                if (this.resFile != null) {
                    return this.resFile.getFileSystem((Configuration)this.conf).open(this.resFile);
                }
                this.resFs = this.resDir.getFileSystem((Configuration)this.conf);
                FileStatus status = this.resFs.getFileStatus(this.resDir);
                assert (status.isDir());
                FileStatus[] resDirFS = this.resFs.globStatus(new Path(this.resDir + "/*"));
                this.resDirPaths = new Path[resDirFS.length];
                int pos = 0;
                for (FileStatus resFS : resDirFS) {
                    if (resFS.isDir()) continue;
                    this.resDirPaths[pos++] = resFS.getPath();
                }
                if (pos == 0) {
                    return null;
                }
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
            return this.getNextStream();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
    }

    private DataInput getNextStream() {
        try {
            if (this.resDir != null && this.resDirFilesNum < this.resDirPaths.length && this.resDirPaths[this.resDirFilesNum] != null) {
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return null;
    }

    private static boolean strEquals(String str1, String str2) {
        return StringUtils.equals(str1, str2);
    }
}

