(ns {{name}}.core
  (:use     (compojure     core handler route)
            (hitokotonushi common entity ui))
  (:require (clojure       [string :as string])
            (ring.util     [response :refer [redirect]]))
  (:import  (java.util     Date)))

;; Define entities.

(defentity employee
  [last-name           string                                     :options shows-in-list, representative]
  [first-name          string]
  [salary              decimal                                    :options as-currency]
  [preferring-language string                                     :options optional]
  [boss                belongs-to employee                        :options optional]
  [staff               has-many   employee :foreign-property boss :options shows-in-list])

;; Initialize database.

(def db
  {:subprotocol "derby"
   :subname     "hitokotonushi-db;create=true"})

(hitokotonushi-init db)

;; Initialize web application.

(defroutes app-routes
  (ANY       "/" [] (redirect "/employee"))  ; Please update this line for application menu page.
  (resources "/")
  (hitokotonushi-ui))

(def app-site
  (site app-routes))

;; 1. Paste below to "resources/messages.properties.xml".
;; ----
;; <entry key="employee">employee</entry>
;; <entry key="employee (plural)">employees</entry>
;; <entry key="employee.last-name">last name</entry>
;; <entry key="employee.first-name">first name</entry>
;; <entry key="employee.salary">salary</entry>
;; <entry key="employee.preferring-language">preferring language</entry>
;; <entry key="employee.boss">boss</entry>
;; <entry key="employee.staff">staff</entry>
;; ----
;;
;; 2. Execute "lein ring server" on shell.
