(ns leiningen.new.hitokotonushi-template
  (:require [clojure.java.io         :as io]
            [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main     :as main]))

(def render (renderer "hitokotonushi-template"))

(defn hitokotonushi-template
  [name]
  (let [data {:name      name
              :sanitized (name-to-path name)}]
    (apply ->files
      data
      ["project.clj"                (render "project.clj" data)]
      ["README.md"                  (render "README.md"   data)]
      ["src/{{sanitized}}/core.clj" (render "core.clj"    data)]
      "test/{{sanitized}}/"
      (->> (enumeration-seq (.entries (.getJarFile (.openConnection (io/resource "hitokotonushi")))))
           (map    #(.getName %))
           (filter #(.startsWith % "hitokotonushi/"))
           (keep   #(let [path (.replaceFirst % "hitokotonushi/" "")]
                      (if-not (empty? path)
                        (if (.endsWith path "/")
                          path
                          [path (io/input-stream (io/resource %))]))))))))
