(in-ns 'functor)

(defprotocol Functor
  (fmap [functor f] "Maps over the functor with f."))

(defn fmapc
  "i.e. fmap . const.
  Overrides the functor's value with the given argument."
  [functor a]
  (fmap functor (constantly a)))

(defn- linear-fmap
  "fmap definition for linear collections."
  [xs f]
  ((if (list? xs) concat into)
   (empty xs)
   (map f xs)))

(extend-protocol Functor
  clojure.lang.IPersistentList
  (fmap [xs f] (linear-fmap xs f)))

(extend-protocol Functor
  clojure.lang.IPersistentVector
  (fmap [xs f] (linear-fmap xs f)))

(extend-protocol Functor
  clojure.lang.IPersistentMap
  (fmap [m f]
    (bimap2 m f)))

(extend-protocol Functor
  clojure.lang.IPersistentSet
  (fmap [s f] (linear-fmap s f)))
