(in-ns 'functor)

(defprotocol Bifunctor
  (bimap [bifunctor f1 f2] "Maps over both arguments of the bifunctor."))

(defn bimap1
  "Maps over the first argument of the bifunctor."
  [bifunctor f1]
  (bimap bifunctor f1 identity))

(defn bimap2 [bifunctor f2]
  "Maps over the second argument of the bifunctor."
  (bimap bifunctor identity f2))

(extend-protocol Bifunctor
  clojure.lang.IPersistentMap
  (bimap [m fkey fval]
    (reduce-kv (fn [accum k v] (assoc accum (fkey k) (fval v))) (empty m) m)))
