# functor

A Clojure library that defines (Haskell-like) functors in an idiomatic way.

## Usage

Just import, and use the functions listed below.

If you already know functors (in this sense, not the mathematical/categorical sense), that's all you need.  
If you don't, this document will not introduce them to you, however the examples below and this might help:

* `fmap` is similar to `clojure.core/map`,  but the returned value's type is the same as the one given (careful if you want lazy sequences; you must start with one to get one!)
* `fmap` deals with maps in a more natural way than `clojure.core/map`, i.e. it only maps the value part.
* `bimap` is very helpful for maps, as it lets you map the key and the value, i.e. `bimap m key-fn val-fn`.
* You can use `bimap1` to just map over keys.
* You can use just `bimap2`/`fmap` to map over values (see Redundancy section below).

### Idiomacy

All the functions take the functor (e.g. collection) value first, which is more idiomatic Clojure than Clojure's own `map` (and other functions). This allows for easy threading (`->`).

    (-> {:a 2 :b 2} (assoc :c 4) (update :b inc) (fmap dec))

### Import

It is recommended to :refer :all the symbols in the package, as there are only a handful, and most are very common in functional programming.

i.e. in `ns` form:

    (:require '[functor :refer :all])

### Examples

    (fmap [1 2 3] str)
    ; => ["1" "2" "3"]

    (fmap #{1 2 3} str)
    ; => #{"3" "1" "2"}

    (fmap {} hash)
    ; => {"spoon" "spoon", "fork" "fork", "knife" "knife"}

    (bimap1 {"animal" "cat" "age" 3} keyword)
    ; => {:animal "cat", :age 3}

    (bimap {:main-user "Henry" :guest "Guest"}
      #(keyword (str (name %) "-greeting"))
      #(str "Hello, " % "!"))
    {:main-user-greeting "Hello, Henry!", :guest-greeting "Hello, Guest!"}

### Functions

The library exports the following functions (listed with their Haskell equivalent):

* fmap - fmap
* fmapc - ($>)
* bimap - bimap
* bimap1 - first
* bimap2 - second

### Defining Instances

`fmap` is part of the protocol `Functor`, and `bimap` if part of the protocol `Bifunctor`.
To define instances, simply extend the protocols.

#### Redundancy

`bimap2` is usually redundant because of `fmap`, unless you are defining `fmap` on top of it.

So when not defining a functor, you could usually choose between `fmap` and `bimap2`.
This comes down to personal choice. As a general rule of thumb I would go with `fmap` to make the code more general and adaptable.