(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51186,       1028]
NotebookOptionsPosition[     49074,        954]
NotebookOutlinePosition[     49767,        978]
CellTagsIndexPosition[     49724,        975]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Compatibility Equations
\
\>", "Title",
 CellChangeTimes->{{3.40459246136213*^9, 3.404592470774192*^9}, {
  3.404592507545951*^9, 3.40459252069197*^9}}],

Cell[CellGroupData[{

Cell["Equation 1", "Section",
 CellChangeTimes->{{3.4045925252719927`*^9, 3.404592556522622*^9}}],

Cell["\<\
The first equation explores using the Gausian function in 2 dimentions as a \
means by which compatibility coefficients in the middle range get more \
emphasis than those at the low and high ends.\
\>", "Text",
 CellChangeTimes->{{3.4045925599648743`*^9, 3.40459257576026*^9}, {
  3.404592645374165*^9, 3.404592652743182*^9}, {3.404592693365768*^9, 
  3.404592704977071*^9}, {3.40459275289316*^9, 3.404592801907517*^9}, {
  3.404599182801066*^9, 3.40459918725928*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"y", " ", "=", " ", 
   RowBox[{"c1", 
    FractionBox["1", 
     RowBox[{"\[Sigma]", 
      SqrtBox[
       RowBox[{"2", "\[Pi]"}]]}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
       RowBox[{"2", "c2", 
        SuperscriptBox[
         RowBox[{"(", "\[Sigma]", ")"}], 
         RowBox[{"2", "\[IndentingNewLine]"}]]}]]}]]}]}],
  FontSize->24]], "Input",
 CellChangeTimes->{{3.4045899131413107`*^9, 3.404590018130765*^9}, 
   3.4045902251526823`*^9, {3.404590263426255*^9, 3.4045902636962023`*^9}, 
   3.404590343414065*^9, {3.404590387009807*^9, 3.404590404725469*^9}, {
   3.404590435955467*^9, 3.40459048105829*^9}, {3.404590567382167*^9, 
   3.4045906318545218`*^9}, {3.4045906775392103`*^9, 
   3.4045907022195663`*^9}, {3.404590822096949*^9, 3.4045908249716587`*^9}, {
   3.40459095496454*^9, 3.4045909614200993`*^9}, {3.404591934593738*^9, 
   3.404591941881975*^9}, {3.4045927190764713`*^9, 3.40459272111025*^9}},
 FontSize->14],

Cell[BoxData[
 RowBox[{"0.9973557010035817`", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "49.99999999999999`"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "0.5`"}], "+", "x"}], ")"}], "2"]}]]}]], "Output",
 CellChangeTimes->{
  3.404590610790729*^9, 3.404590642463513*^9, 3.404590704166003*^9, 
   3.404590833180179*^9, 3.404590962078155*^9, 3.404591133788857*^9, 
   3.404591298058092*^9, {3.404591366488064*^9, 3.4045913893295193`*^9}, 
   3.404591533217491*^9, 3.404591792824336*^9, 3.404591854026661*^9, 
   3.404591885866185*^9, 3.4045919199616537`*^9, {3.404591961843623*^9, 
   3.4045919730002413`*^9}, 3.404592058837612*^9, 3.404592130350133*^9, 
   3.404592721876026*^9},
 FontSize->14]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"c1", "=", ".5"}], "\[IndentingNewLine]", 
 RowBox[{"c2", "=", ".25"}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]", "=", ".2"}], "\[IndentingNewLine]", 
 RowBox[{"\[Mu]", "=", ".5"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.404590030229046*^9, 3.4045902270164223`*^9, {3.404590273546677*^9, 
   3.404590331264193*^9}, {3.404590497451509*^9, 3.4045905239408503`*^9}, 
   3.4045906381164227`*^9, {3.404590707642593*^9, 3.4045907138072567`*^9}, {
   3.4045907445668783`*^9, 3.4045907475683537`*^9}, {3.404590909624385*^9, 
   3.4045909388294897`*^9}, {3.404591032050804*^9, 3.404591034544088*^9}, 
   3.404591099008032*^9, {3.4045913459919863`*^9, 3.404591346733129*^9}, 
   3.404591522596305*^9, {3.404591607045126*^9, 3.404591609846302*^9}, {
   3.404591781905992*^9, 3.404591783782247*^9}, {3.4045918435318623`*^9, 
   3.4045918455222397`*^9}, {3.404591882075845*^9, 3.404591915025386*^9}, {
   3.404591946805565*^9, 3.404591949720294*^9}}],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060646064*^9}],

Cell[BoxData["0.25`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060662718*^9}],

Cell[BoxData["0.2`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060664218*^9}],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.40459206066564*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"y", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "0"}], ",", " ", "1."}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.404590153274328*^9, 3.404590169399311*^9}, {
  3.404590200979073*^9, 3.404590203442346*^9}, {3.404590242183119*^9, 
  3.404590247214078*^9}, {3.404590543289835*^9, 3.4045905433580112`*^9}, {
  3.4045921225266237`*^9, 3.404592125613811*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1mnc8lf/7x2kp+SirkKJClCiJBvcru1BIlBIyGhJCJdEgQiUiO4myykj2
3mRvZZ1DxnEc5xhFQn7n+8fvn/t+PB/vcY33db2v+3o87p0W9metV7GwsJCZ
j/+9tawpraXjhoTnUkl71f5mYo2qoANJQA7zav1tPEnNxKF3YVFfBdTw8/X+
NkGeFkK7sTvjrcA5BGhHfGQLaiHOW80XvRawwuEntArb6FaiX+aZ6ksBZxyS
o4Y8G20ngt/xl4pduoN/HsZ0J7kOQmtTsmJx1F2YHZgvfurZQWTTGw4zhO9D
Jy9dVlSsk/BP4ZbQF38IsS09ai13u4gYPl1vP4GnOBt+baTg/A/iQWNopVH+
U/SO/CpbyPtBGHmRV+2+5IWXvpKXPmzvITh+335UEOWNCJODCwbjPYRLR7AL
TdgXqccv8qa+7iP0g3pszoj7Q8hwV8p6ATIhpb07SbDGHwd/SzQ0GZGJ9att
x0avvYKk+9WSe2/IhFnevy8l5wJQsJX64iHfIMEnGSB9ISQQ//UfpueKDBFP
1n/d4ysQjMDjrCqNV4eJvZqBPhkOwei4We7Vlz9MtHnZj/fWBIMu60uS3zxC
iK6W+iR99w32Hj17glw8QlQvf5DuaAvBBhOLm4FSY4S9ouerZclQqHwpePf0
+RjB/+DKlPiTUAinNz6bmBgjbvzZnnFfJgyV7CcF936hEByzIYeFX4TjZQvH
+nVnqETWwTshJ3+GY7GPV0A2j0qYOhjM3z4Wgaz66d0rYhNE2uSmvEpKBEx6
12oGr6ERZyk+ijbqUZApCMSFrkkirN9VNetfNIoeP3JbpkwRykLGHwYM30FU
g5y3bf80Qb2osHZ9yjv8FiDnwnGa2EG7b5myPwb2FocnElamCfsb8mIsfTFg
1fnqbrVnlqj0+dgZzPYez/7rbdzmPEvwJ/J6Sx56jxu7Srj+lM0SpaMzo2f9
3uMIZeq/A1d+EdxWaYkfj8Ri4valXXypv4mrnjuMj1nFwmlYetFmzRxREPty
Q/OrWLziXeWw3mSOsBq8afNnNBYWDzdESW2aJ7JMJaS038TBRDTbNtrrD3HB
+H3a1PQHzMuPJT3OWSQYvefYYwU/QupICofB9iXC23S9tYHqR7CphLv6Pl0i
vlraC2YHf0Re9dYRufPLBKedktcDhXicICvzsHOuEFUePy6uc0/AoNV44YoF
K0zWvszK+ZgAXvO6calYVsw8O7H5RlMCZKvijeWGWCHyMqGqXjgRu5+v2dNv
tQpuoXcOBJYnwuzSV6NR59WQ/cy1Tmh9MgxDG2cdy9fim3SVeeOBZDQMqRZ/
2LwO5l9cCh4aJ0PE6Lv1oNk6vMwmOQwmJ+OmtWOhDysbKKUpvfGnP2Gtf0wT
Q389ojtPfTkY9BnyFw0E1PZuxOELyxt/FnzGOz77Cw1+G9HQk341ePgz5nVb
FsNpG7FA2io0fzgFicr3Q/kyOXCOOuJd+D0Fyd/5frAacGLjyhMTzR1p+OJ0
78Yx6maE3ThvKqWRhuedTRZuolwQ7ZAy57JLQ+6hyTtuZlwgkrote4vSwLEj
YH1pNxfykkKycqTTUe39VCyklRuTBrRC7aZ0fOcfd4+m8UJuQ7cSMZSOcqqK
z+AhPrgWlxUfmEsHq+bHo+xufGCTDC3l2/EF9w/5223dtAU7/ylXkm59ga7M
kW67E1thmBha7/RfBka2/BQPbxNA1GUPnas7M/DsnkPmC0lBDHHfarxwOANf
EnJng58Iwt5dpVnpcgaqkzfYTcltg+/ZyTa2lAyYPlv9WiZJCEVLKj2ROl/h
7vM5u6lOGGsy9l/yN/+K4p5fMfqCItC6xt/32PkrRLQPig7piqC7dbLfOuor
FJdzvZcLRTAdHzYoQ/uKRDPTc+fe7YSYPp1S8TwTE+Hphie9d0Pwkeaxa+8z
oWnb+Za1YTc2p8Q8Z8/JxLQD74uP3KL4u95AWn8oE648+YO5saJoKc1xGjiS
hSflHL/MmsTgeuDJvz8jWXCN2rdiZiQBe9Me3ajFLFhsEd0l81kCVi+YycWV
DerziBnB1ZLQpYyoeitmo69e6LJRpiREY7R8eYKy4TZdUFYsug9Nm3h5pU/k
QPZG6ka/E9KoULpl3WqYA9/gjDOdSdLIvVmd7XwzB68jQ7678MogrsbFuCAk
B1sCW7b9mJSBy6P+6JOTOWhYDv6U9/0AdjHiJS0jcmEWLGVCL5HF1u0sD9al
5+JtdN/z8yyHwKFt3JBUlYtTPiwIUD6E+fiN9lNTueiNWU++X30IDaYOme6a
eWh5Y6Dn1COHe01HEfYrD4FSvwjsVwCndNbIt/X5sLt9Ve75XQV8eHngxaJQ
Pijdl2XSSxXQqrPnh6l6PgI7rR/5nz+CffW8TmIh+dg9Odow8OooSDWM+AyF
AsjZEcmzUoq4u+fm6WHtArSVjRTPPFUEx7PRWT7zAvB3OafP9CviqEb/ifs+
BaD1X19Yea2EoMq6HvwoAFW64vjbDYBm2UfORtdCiJz8lZbOp4wBkZ1Z//wL
UXpt5IC5ljKcH0ddOhBXiOrFIY2ER8p4j6DEoPpCuAgevLeKpozFoscqF4WK
oPCk9a1AgwrS8i/dHSsqwu4PO2WUPqlBQ7BbSKCtCL+9jeYlqWrou3+2Qmu0
CDmP9MS/Sapjw9FTm1M5i1H0hP5H7JM6LHPkk53NivH86Gbhl9ka2JrJNcDK
WoK0661sRdMnYfJi8dzwlhJmvevOXaV6CrFWI/XVUiWQy8/2JN6cghRfXt7z
CyW46LyHM05RCyp3zd/wpZdAVPbP3M1QbchHnY8PlinFSo6SjNOjMzD2aRj0
OlaKslMD49cGz8DNWXn7PfVScKYm2jxW00WZzr5g40ulkC7aG8DLpged5X9P
djwrxXeXW+3fu/VwxTT+cuJAKXKUtx9WCj2Lp1rbwsPHS+Hrqqu7te0s4uUD
Ovx+leJ2xlLd2/8MQON01b7FXoZskSCuHG8D3C05fVRWvgxentbTp5+cwwuR
37yFL8uwZ+ZL5tdwI6Ry2OilhJXhbf/t/ENkI7T+GXgeHVeG0dnUkod7zmNL
a+2qJ3ll0Pfy5XiYex7vn0RNqY+UgYuaEmgyfAHZQ6oNzYrlYNFz5X1sfQld
J59Mv9QsB098xRfx3EuYSy3eonO2HL+eUEYyNppA4cHRK7XXynHrCyunV5YJ
cnlk5kpfl+MZ63YdPV5T5KkJimRQyiGyXLj91GNz9CSfV3eYLUdpd/L8uS/m
+Lv5jY30v3I8jjPJHB0yx7H+TVnJPBVQ1+Cdi9G8gvw7a7XiiAqQL6Vyvdlq
gcL4Kafg4Apo2/BcSWyzRB+HdPjZdxVwOfWq+QuHFZYcbxZvTq7A6UJnspGm
FZQwuv5lSQV4SpYL7xdbobi7960XtQL45NmsnWmNkvU1NXdPVEJO7U723ZJr
KLd5u82YVonoDssMeTNbfB2/edN0rhKDK98r9JJt8eH6sQJLlirMzwcOCs/Z
wutq90U73iqkW3Nr/Xx1CyctuCI8FatwxWQ8WrLBDs3GXvypL6rQHMhJ8s10
QOl3g+tfQ6qgyUF9LUR2QPr5Xbm5MVWwK7N5sIXjNl4blpyvyKwC+7Z+DVXr
2zDSXwj53leF55b578KEHNF38hbf6v3VOPL5xujvd05orDluvV6hGlH0gBLL
NicUa7Bn/adcDVuNi+Maa53xTi3hHL9hNZYHzlAdbJ1hcWIwaL97NbZa+/Pb
nbgDioIh94XGarSM6v8bWbmL3+JKm1Ju1eAJ5UPr6E9XEEMqNX4uNbCslkoI
l3oA77cnH133rIHevL3S8p0H2MJ7jrE7vAZ7zse59rG7QZ71ZnNEZQ1IYrOW
okrucOkNe+WzrRYZC436+6oeoTQkWvOqeC0+4Gp2E8djrD/7YUX1YC1S2+rO
2Co8Rnhtmv2KRi1c2a4ZfX/5GPlZ1bp3HWuRVc3p6YcnWHr1a5PVt1rsuWwV
zpXjATXtvzXKHbX45brq3NyYB16sY3ksTKqFt+pxttMCntjuvnGq51ctJvhj
yAbuniBsdrXoi3zDU9GMG2Stp3ikpheAe9/QNhn9qmzJC6sWPm3eJlYH++o9
jvrlvtjWqDILmTqM5VmTGf98Iff+R6fV0TqQ7LncOBT9YH2KLTL1dB2iLeuS
K3L8UBtuIaZytw4RDTn7VLKe49UxgWM3auqQFLxyV/3bSyRypgv5t9YhNVt2
WYbTH6VDGisZvXWooMdR4w38MePnXLnEqMOtjtI0JbI/jHqbzwTw18P3RuMz
XpYACLl5W+bcqEedUgDX6P5AHNbbrtHnVI99ewXV5s8F4oxopgTrw3oEeVWe
NXILxKOGwUmt1/UwFWlgZWkIxJCQkstAfj2SlyMzNtm/RlLR7Iu1HA0w2nHn
+evKIMivmGcbpDZA4o3L/o70EOicLvVQz23At2+zsvGDIbCMFNZVKG9A+5CK
YTt3KAIUBsYEuxrgcC2ZS/luKMbtLwkMLTegi1PR7r5yGKLIhm4Opxsxbrvg
3D0eDtZyLZWXtEZc12YbkfF+C/7NyZyP5hqhwXXz292Kt5A23dDrwNKEG7nn
SvayRuPi3xqnc7xNICTuKPW5RyNTVv3jNsUmVHuM7rvr9g5X47A++XkT1Ix1
1bxrYtDwVK6pem8zBnndQ9jY4nBsU/2qwMPN6EtcU6J/IA6J4VcULp1oRq93
WumYcRw8U/1jGIbNYCQ0zP5JYc7/TnHkf9KMGq6ojwXGH5C47+1Wm+5m+J3l
thYu/QiVcY/0dSotsOpQvGdYn4j70k11NzVbsGK5sYT6LxHpTgIjLTotaCjq
sf8hm4Qd/9IEIs+34E+1Rn1lZBIWuPs9ZG61IMHxbBLpdjLSFRUML4S1gPGp
7a6PzGcIB0wsJNFbIHzzEEvpbBqKrzxKyphtgRy/hPCLrekwPcRjXPCnBdRL
VgbWh9MR1XUst2FVK/wvxGa9u50O/u1+dxlbWtHltv/+UVo6uJMlZuXQija+
tEJJ6hesrbSmlbxqBc1ML16FPRMf3ixE1ga3IvJ9pNfE/kyoXXup3RreCupw
k0aNfiY82LOSh+JaMUs4i/NHZOKf3poba3NbcYj3rIno/iz86Y8d0SK3QvHX
L1fOy9mYmCcNdB5ow7HoPbpWI7nIvvaqXEu+DaQ3R0XP8uThcTcRX3K8Dblv
Iy54KOdhS87bW0kabch++jo/OTqPWX8vLbmZtEH95PkLO03yEfGrS0DUpw1+
yntWd/4swMnpxnOOpDYwFD5srdhTAp4r7kfGhtvAT316xNK0BAMtUkIm1Dac
TGvYq/OmBM7pz3+q/27DZm2TmCXWUryzP+UosLEd6PGIt3Asxdxk5atS+XY4
tqheFL9Yhg/UgjpO/3YIfNN8vkujAnahurttgtrRcIqDL9i6AgpqPx9UhbVD
vJeitM+rAnVv2fe7xbUj2U0mva6yAtN6xq/Gc9vxxvPiULN6JYicOYPKn+0w
f5EgzqpbhR+eB/vvH+3AD8ULOeYPa8C5PYExPNwBrvtlbLoGDThh5Nn/c7wD
Avf3lRbfb4DjK7P6IXoH5HM0ZfRjmHnFyp9A/tOBOgHKgYHJBkSP+pj2cXRi
+8zf1DC/Rkin2zS2y3WiPUFmr39dE06rSn8qf9oJtpmwvwcyWvDiRtbVGNEu
2GYevLH8sB3UEyk+G/d2oYd36o8j0y5N/o/Jd2W6oOLyIWnxSztW1QTTdY51
wb7sHaEx0o77os53F3S7YHRan1Ss04GrJFnvsw+6cEe6z1NWuBPKhukf17R1
IYXVu6CgtQtzJz4NX3/UjXdcnV+MbvTAWbYyc0vFd+zFrQL9LjJIqZXPW3f2
wCyM6h0xN4xFm45ISddeJD1tkpnto+Cc/OVA6Ue9+MZpzJFDpeAz66j3oae9
uKZL2uf0hwLTsPnbSv69eHtFktTOM46yKsGT+rG9OKxgXS2nNY5nIld+udT1
YlZx206LrHHwdE3q1Ar2obgv6eL3p1TYvr+r0ijcB8HjxwYfBFJRabui0Cba
hw0dzzj5oqm4u5prd590H7I9sjdK5FDx44DcAkOlD6F72M83Uah499z149ab
fZhhV/Zl15rAPmW2f1cL+qBME/HOXk1DevKnPd9L+9Agt2r0+yYa5Hj19E9V
9+Hw0DU52jYaFMfCPuxr7cMmlRXFkUM0nHm5V3tqtA9rJwWtdljS4PjjdNh9
7n5MdNn6hxXTkHc7WPbFjX7Mn0oo/e/GJIjeIybLdv2o3FxovdNpEuVq/V52
zv3oddGS2u0+ibqt4j/0HvWDN7K4fipgEn1FOY/43vRDs8hNKCNnEizsvQ3R
pf3oVm/LKmClQzN257UvWwfwclOm7bVndMiFcYpXCw3gVlvOWKg/HSL+i8M9
OwdwOWNLY/YbOv7e77RYIzWArgOZsSVxdKTo+5qePzGAj7uKuZeK6eBhnTZc
vj4Ax7l98nwzdLDM9/Ny2w1gjmPaRfwPHTRaXbu40wDOvrhsKfaPjurvH/T1
3AdQuvJjFW0DA/fTL5yOCxyAbt9JpUgRBkhmpWqn8gfw2FE82EWLgQbDlNWm
JQMI+S1jZabLQK52RLlj5QByjyYePXSOgdcKzieimpjr6xZa3l9mQH2ThCJj
aADuCqeKwu0ZkF3Lt7iaMgADHZbKMScGdiyy5vNPDmCq7fvzXS4M/BntVVCZ
H8B7ZQuYPmbgU/GrQ282khD1vdp88hUDYZluM0mbSXgl6hkRE8TA0+QbX4r5
SPjzadT4RCgDpiGqMhRhEjRMXp1Rj2aAy25+73E5EpzbqoytPjHwz3J4XPco
CQatO9gfpDJANW5NtCJImDGP/+/hFwYq1T+J+58kwVI2f/5kDgP3tpvtGjQh
4U6qbvl0GQMWegeM+q6QUJQZc9S0koEznqx+3VdJeDRjEZNTzYD4eNx0owMJ
Rt+M9h2sZ4Bb6I7YtzskFCrYauo3MrB8RsO40pWE3Jh8FdNmBjoyKaX5T0no
MVevJdoZKB3L+5XlSwIp/r42dyfTfsHnEl/8SXDp6XrX1sWAx+P9AQlhJAwL
3k8T6GHA7uu/iti3JEg/rbeK6WXAeLR5/m0sCUsfr5B4+hk4oONoFvyZhMU3
MwJlJAaEHqkGvfpCwn9nuDr/khlgy+Ct8csmgfd9gfbOIQZmhkf+ehWQ0NTQ
80DuJwMDW3Okn5SSkL7mgaXcMAN1Wj4WblUkNN+rZ9k5wkCWu3HIvToSLhvt
OPuXyTHpe+scm0mo7KIYlo4y8OLn4vKtDhK0j1WwO40x4LKl8eCNHyRcar1u
z01hwPJUtLXVAAmGKzke0Uw+42YfbvaThGWlDNWt4wwcSzvReJFCgoeI2xc3
JosPcbEaTZLAY3S5vonJXHw/5fRnSOD4XBrwH5WBJc3M6zrzJBRvkmM9ymSK
q1eU5hIJ5a+uC+kzmWq07/p7FjKmTWSHDJlsPsWzSng1GeQ6n7OaTO7yXYqM
Wktm9mPet8SYrL175LDgejJOe10/NMWUV1rY2BzKTkaAWMCHBCbLG2Xf4PuP
DILjSZk2kz8zolcHbSKDcmjIr49pzy7fZ283c5OhmOnOepHJYbscFPx5yUgu
OSFeyfQHZ+GF1o1byQiMOf5XkMlPDZVv+gqQwZr9/qEp038LdMm1bEJkiDt8
y/Rn+tfOh/vd0x1kSOhIRX9insfwzsUjq3aSUdd8VTGLeV4t5xpsl8XI+Dvt
Ge0/yIAGPXPdAwkyesLOXDVlnnfhs7cxf/aSsYtWShVkxkNCvl3HrAwZtxZo
shf7mPFx7rzdbVkyXgjEL/Yx4+v1JNYz5MiQjlv7XOcHAw9FuBSpR8mYajq8
YYYZn7/yFjqvKZLBrir0b08HAzYGQ/YjBBlHMjqqtNoYMPT+GkdWJUPos1Wv
URMDUjTDjd2nyRB8fdDbt4p5f5zTKfHTY/qbg1Q0Xc6AapGKE2FABvV1nI9q
KQMX/WV6P14gY81VN3pcPgO+BzZ8crYkI/c4d8IFZv7yhq+YSlwlI527ZScn
M79jWOe4+66TsVXf2yIlgbl/25Crqh0ZTa++nU2KYWDUuVCL+z4ZfmMXK0ID
GXDsz/hX9YB5Xk6qylEvmfmpnpRx/yEZHNE5FX6+zP23hggOepKxP27hj9gT
pn559tQ0fzLG44d2GjHvs5jlXX6nP5AxF1E7/lGTad9VAYI1gYzdHNXCuioM
5DRtmslMIsMoOG5hSJGBpndLxkJpZNReG6uuO8iUp9wlOZFHxkKZLXeUINNe
b99vPs3MeAxa1NOj0DFKf+Su2EaGtr7ao6RBOm6fv3twqoM5P8hBiN5Dh4+E
Zfj5HjJ2lNB6jzbSkV2neEN8hIxZybjV/enMerBpan3lXzIk7z0XNHOmo63I
79mpZTJ4dEU2/rOl47Wt2LrmFTKeiq8bfW5NB3fdxdU9awYxQgoMcDZislfV
MoNzEKRyR4UHCnRsXoyY2bZ7ENsosdtt5ibBMabe56Q9iOLiM7ry1yfR8IZ8
ceH0IK5wNUU0mU7ihdqDHw/1BkGkzHw5bziJjbHpXb6Gg7As6PJSVJkE++Vt
re/MBnHsb2Lk2W3MYGufqqp3GsT7D4FPS+poWFMSmbY7ahCubTez+YVp6FFU
O0mKHgTLzZqVRW4a0vJp5Ij3g/BoHt/Uso6Gi9lK3NwJg3gS/GtEiz6BLykk
Z5aMQTTHbeH3L5yAadTuY/01g1jvH6pvbjSB3PufKkNmB/EgL5cx8oiKm3IF
PzZoD+FbsZmMfDoFn05ZxBTPDSGe89bdsNph/J4Q3Dwa8hM9EU90jVYPIstA
c3Ww2jBi71bYOR7rwaOTXu8yR4fBXRmUUFzajjbT6yYHxofh82peQiepHaJ3
tAU+Twzj+LsT2eOB7ah7zxUUNzWMYNGb/IaW7eBdfOv9+u8wzuq0T06ua0di
SvYtB84R1LKGTkvrt6GFm3JcSn4EXes1+YVnWrBLsv5PwpERXLg8GVnY14I7
SM3afXwEG1ikWG/WtEDQ1llm24kR2P+zevI3itlHVbHsZtcaQaxAeM3wSWaf
dE+AnXJ5BMqerb1tms3Y2a/1Pc5rBHtc6ox9GhvgV348zdBnBJuln9eWxTVg
JkHKm+35CNp8drzd7dqAckdOuZsBIygIXOVivqcBVuvbXslGjiDr5++fxZ71
SDxkrFmWPoISbeFFDrU6SPtdyx7oHUGp0qPGlqEahNhfeBkwMIJHSmZsXMU1
WDl3ykplcASsYgc23Q+vQYvwPu740REkh09dKdWrwe0s+q1b0yNYz0X5vbes
GpnkO2JL60Yh9b6E/WpSFY4pPA0WkB3FzwVLc/7QCnRZCMi/lRvF74u/Vi7d
r4CTf2q3iMIozjsINpdeqsDnke+CEoqjyHOcq5gUqcCO4P3v5TVG8aph+k77
53Ksmu5KMbg4CtuN9pOldWWoT5aseekxijsqx0wyd5TielfxdS6vUQz71i6s
rCnFmlXn2N88G8W/DtEnnV0lIIwfno56MQqxkBOsx2+XIJ2tvT05ZBSDb1f5
TCQWI9jKjVyTPIpYnsMhZbuLYLKjeYG1fRTmSOmU1sgHp4BjVkHnKDiSZ8xD
t+SjjIfv9p3vo1jO326kOpYH8Q2XKJT+UVB3O8db+eaBMTva1UwZRcPiOkZ1
Sy48vv37+vbfKNzzkjh7buYg0Vna7ujeMaypFxfLaM3ERftWyVmpMeh/fWAr
lJyJ/2ycRz7LjOFCW8KWCo9MOJrlm4gcHsNO0qpPlXKZOK6loc12YgyHi/9z
fh35FU3CphKdhmOYK1t/Tsw5A7/rXg45PBnDtNm20y9009G3sfP6kucYBO+v
6MkfTEe5jhDjmfcYMvOy33DypCOgKXkx+vkYrJqPqrxOTcPethrexjdj6Ato
WCirSIXpD1ZNyeQxqM4IP/757zOqx+58Gmwbg0Blh25gVhI+SxQdvNU5Bh/V
PRMFnkkIurEm90/3GP4eeS2ocDYJ5hOvKzf1jyHQcrho+1Qi/tLT+pXGxhD2
oarrvUwiZObGN0UsjqFt7mH5oaJ4hK0xdT4rSsGdf9IVC5s+ML8Xtx5uFaeg
sHiOdJoSB6uKlt+6khTckPW1HS6NwwEP1XunpSm4O8bl3e0Yh9oVCdeTRyio
iJuMbPgRi/m/s48IHQo4RtYuJH19D6Np3+d7nSlwvqdPnpZ8h0I9VZ2kuxRs
EFQt+TMejV3pSxwS9yk4Hqel45AcDbqdvb/YQwp6ubzXpUlFw4t2LlDEh4L6
I4rSF+XfInNMOHRLFAVhpX6Xhy5HgmcgK3ZVJQV2mWf0Py2Ewp/D3T2nmgKG
n6La+fJQsB9Xu2D7jYK4DSc5HZ+HYlVY239dTRRmXSoxn94Rihl9hkvSD6b8
O0uZq7VD0FIloavHoMBYxXkTKTsYOr8YkmtnKPg6xPZa3DsYtbty1uT/omB3
y3mRNsNglDxSz9/9lwKDKx1VZ+eCkHrUQmx+zTj+W2O5m3I8CC9SIhffCo5D
iq/oV8f3QKzvs+g6u30cn9VrgjanBuIp+94vbCLjqGcz2hPvGYgH13Kv3hYb
x3T35pI+mUDY7OxsVTvAHC9WH7j6IgAn33AmTqiP4/Scv0Jnsj/Wuj85d/T2
OAKVs7Kvavghc5q2UOI0Dob111jHDX6wunrhncZd5vrkn4OLDb6o1JWhGjxg
9rFbGv96GPri6a7+R3Ze4xi94XBEx9YHa2qPfIoLHwfchq/wpHsjU/GD3t6o
cQxtV/QLdPWG1ZdNc+nR49gbJLn6sbo3KiNGTxTHjePFmHtdcp8XPG8Fd31P
Gccl2Ve7dm32wiqeKVbO8nHIZQhM0v08kfHsUkJw5ThszDIntph4wmKpWmdb
zTi4H4whbr8nykfehko0MMefBf032uoBj1zt/apd49ggOebMIuwBVtOECy7U
cTStO2o1WfcYLEmmaUPcVATv3cq/ps4N1bRuu3d8VNTyNCv3urnhxQF9aRN+
Kj6Pj4faHnDD1lzVlM7tVNC0uvNzwh9AukbiU60EFcXzhazVzq4wGZmJTyWo
EH5q0/lA24VZb2yv3lSmwn+VirT6BhdQbEfEJNSo+DMhGPKl5h6cfnV/eH+K
ikZJH2E7jXvwW10UG3yOijMOB+7oad9F3s5n0a42VNw5lREZfNsZD61ZTBVu
Mddri0lNHXGGWtL97b/sqTDhOb6hh8UZLQdso27doWKSMK8xeO0ECvQjzB9T
0WSzI6aowBFbTLeFaIRQsZXjsJzVnttwjEh7yV1OheKyFflmpi1yliKelVdS
ceizkHutpS2WTL2fONZQ4ehzsGOWxxbPdl++09ZAxcarcWZpd28i6jP75dfd
VHTQ7js8U7dBVbG1FPckFZECf6pk2a6Dfae+eDmDCpteFo/48mvQ81QUcZyh
IuTayNHGh9fQo8nD2zZPxRxXscj+haugt5QuBq6awEqzGS/7nDX4f26r5+Kf
YNaHaN5+TitcVmerKhOcwFLBOrvKDkvEJswU394+gW3jUUc0Ii0hZfsto3XX
BPi06q/x7LWE8u+7EYH7J1AWtFT4+YwFbNjabnCpToCx9zdrUoY5ivb5rOey
m8CUktYv37xLkO/Y2vjagbm/Qc9BY9tLSHdLCOR1msC5sxu+0oUvIbaxWpDf
ZQIHqDvOW/tehI/92v3CHkzuONKka22Ms1899PeHTKBvolA+AudRf4l7S1rY
BNLu7hP7t2wEtTWxPQciJ7Bobqb5X5ERFAzLLOViJpDFceiHuJIRhOZX7hxP
noDrW97qbeqGGDvmHnGqeAKRPBJlBY4GMP/JYVZfytQ/yt1M6LgBep5H7T5d
MYGzry5d27zGAA19BZ/1aidwveHlvpTQs8h4+Lf4fNsEqp652wdV6cOt/N5P
69EJiL3L8p44poffNmyJY5QJXJohfx3aqAc7nlDbGxMTMNxXO5yer4srVtm/
bacmMLCuM/zOal1orPvN5vx3Aizf/553ijkNLi1HKQ9OGnw6vLcqrtNGTNmm
jce4aHhjuy2SSNfCgaMp49M8NCTsmMjBJS2ckaDEXxGgYc/I7xXZzFPwW2e6
U1mUhjM9kauDb5/EmopTW1iO0aDsaiGxjl8DQcfGfuUo0nC5VYavqEUduzKe
ttuDhoCya/e0/NRx4n1JAEmNhqH0dEvSihrcHx3eWKJLw6utri8yfqli7vhO
lofWNMSv40nmW60Cr6/FA4ev05CicK18b60yePeZFE3a0MBrY0qZfamMQ4Kh
rpcdaCh0PeEasU0ZDn84fis+oMG6wOPNKpzAeOaf8cUAGkr2znYeO6UEF6mQ
2q9BNHA9DH21k6KI9R8OJdwMoeG2cP77wz6KEA+ys+qNpOHDudum3+uPw+L2
8EB+PA2vM8+s+Wx+DH37W9rvF9KQKVHfUFWkgHcTXO6rS2hY7an0WM1JARZJ
BuIvy2iokLrkGC2pgHHRbpeYahoymgyre8LkMbdtYHtNCw1R6tWGh58cBhc7
7RrvCA3bj4089Lp3CB01+7mix2hYH2Cf9fnoIYR52efvodIgg5MuL5ZksYN1
luM4gwbj4Aept57KQurPwpcrCzRotvaqPo46CI1RtqXU/ybxbHHfCY/vMtjw
4dTHI5snEfeskUPAUQYNV56fKeeeRF3lx8QRDhkY9HO+79w6ifKfToXcGtIw
7+DTWNo5icsLrEpm1VJ4UL474JT8JNxvbbr5a1ESxGPro+1HJsFp7R5ukSCJ
VUTCkMnxSThINPB3GEjCJ2/vYYcTk1jR7H+clSaBkPSDPSFak9jUtPPHLqc9
SI+G6DCzb/o76BWgIS6GWddZtitXJuEzrW6wOCgK+fMJE/2Wkwg/+0H8cbQo
CjZt+trN7LtcsgRrpwREUf14QLnekSlf5F+ZtOBu9Fq4m2V4T6Kme90veWIn
duCgqozvJLjpw6bDa3fCfNuI+OfnTPl9EhFoEsFouw79Y8AkMmRbv8ybi2BK
Tcg9PGISAkUpybeFhLFuT0HE49RJ9DQtRFVxCOHUavuHy+mTqByuCxBM34YX
pF0Wrl8n4btdSSzw3DZwhflJOudOQis78W9njCCENlzMvVY+if2tX1stNQQg
O/Gn80zXJKKi0qS+l2/BnZrPefXfJyF6eLi14e4W5MaZvz3ZO4m+XneRjH1b
oGRSa6VCZuqzdixUNYwPJxtDZw9TJ9H73jf5sBsvLqfJc23/N4nJ6/HnOW5x
I/viH84WFjqG3UIevpDkBue6fA7P1XSsTvy4f36UC6UmSuvH19OxbKMq/9iK
C7vY1VYyeehYo7hgvclmM0at9Cd1JJl9uHn1K6uj/4HYzDOxso8Orfdr1Dgb
ORBa0EHJkKZjXPe81WELDpzkvjDML0fHvS3CRygBG5FcYto7TNARUz0Sbbyy
AXaCtt/cztHRVSkef1WIDdVV+2tkztMhd7omNbtqHYRvMyqHjOloIbdQjjus
Q0uNY+lJMzpslqyKO2vXQvbO/RxeGzpSzqif/v5sDeabvT9+fkSHWZNrcf3R
VdB7cDLOzIOOC4/FTsb+YkWiOPt7bi861M7cSnNMZ8VF95dRLn50/NA43jy7
lxWFe4OD1N7QEW+9NVloHwsee71/0pfMlJcRdCkpeYn47x6b1pUUOga5qqvo
qktExPVb3KNpdLgGV3AGDSwSX7WPxjEy6RhJ8wge3bpIjHK1Vq4qYeq/oph7
ImKB0I5mWS/ZTkdVeE+0WM8c8f3V1ZaUTjo2vKgavfJsjrB60hAm+52Os06l
UoWH54iHVmGSiv10mHev2lH45jeRvveAtu4YHQYfaFNeFr+ILTlm/ncW6Xjd
OWuoKTVDxCVWGf1dpuM/SXmbyvFp4kDEPuFHLAxsY9u/KJk4TZxyn0/zWcuA
HF9iYOyeacJN9VVr5CYGvLrXvZw/MEUMNRfzlu9mYFCueuJBJ42wLxPt1xBn
YLx6LKHHhkYsZfh9rJdgIFkp4nIGK43gCzGS79zPgB9P/b/cQxPESRP6eYoC
A6zTJS5RieNECmV7JKcOAws2EaK5raOEXlKg+7czDHx6av3V5M4oMXNjrflT
fQbq3tD+XBUcJY5M0ET/GjEQF6AvGnZ9hCifLEgducJA5L2rSoO8w4RVqkxg
jBUDPs9/qOyp+Emw2cc5XbrGwCUOq4JPjj8JnSm/I622DPxzkY273DlEdM0Y
lxfeYzDjZmgrJXGQcPna+OGeKwOX7R5zfDAfJLY5Kz+TdWdgn6ai5gOBQcL8
t4ROogcD4T+z+G/6kwnq/Hxn0EsG1A+Q9pRuIBErS2/GbeIYiB6M+B6q3EvE
Fm1oEItnQCxB9V5XSw+h9tA9lZzIgIPTE6OOKz2E34qVk1EqA6cNwp/M+vwg
eFfJLSvnMZARrK3HMdFNZJcnkJYKGGgL5twc+KybMPbcVp5TzID4aYeCWLFu
InrN6mf7K5n7TY/pGl7tIiTY2jYLNDNgd/yJxfmFDqKuRn22vZUB0fxbP2Lf
dxC3fPI6/TsYuPHfL60z2h1Exob3EWt6mP7xlBJJj20nFDkcRKeGGQjY8Kti
85U2Qp+L80jNXwZ2FpiUs/O3EH5rV23rY/JIjYXBP74WonLh9/IUk88suInO
8LQQ8kP9FYKLDMQON3v3bGohBL+m6NoxuaZsh3YqWwsxdO70Nb4lBgLHMkMr
6M2Ec9iLEMtlBvbkP5udSmkmUl48vu/CZDWnquWxpGZi9LGzyUsmHz2u5036
2ExcuGGyK4fJWv+4uFveNhNKx6RS2f8xcPBHEnfOy2ZiXV991Rcmv/DU+RR1
q5lAS0liNZO1Tt8JirzRTLhUfn3ey+SmpZU/EdbNBPVzpP7aFQZ43VgUIy83
E03uN/svMPmECW/M+9PNBJujWektJvskZ9z+cKqZOHHVIM6DyX9GlEoT1JuJ
jDPHb3xm8kA1uT1NqZmYUJHRKWNygnJvWObRZkJUYbdMF5P3nfPpyTvcTJju
28o98b/1tj/CSg42E6HCG3+vMPn///f+P9XtBL8=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{530., Automatic},
  PlotRange->{{0, 1.}, {0., 0.9973554056076904}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.404590172042761*^9, 3.404590204208187*^9, {3.404590235718945*^9, 
   3.404590247846108*^9}, 3.40459045359381*^9, {3.404590511284226*^9, 
   3.4045905736359453`*^9}, 3.404590616057582*^9, 3.404590648794223*^9, 
   3.4045907179598627`*^9, 3.404590754860753*^9, 3.4045908401675653`*^9, {
   3.404590924410165*^9, 3.404590966762342*^9}, 3.4045910385385303`*^9, 
   3.404591103786969*^9, 3.4045911431998158`*^9, 3.404591226559553*^9, 
   3.404591300714115*^9, 3.404591370567541*^9, 3.40459141835938*^9, 
   3.4045915398720417`*^9, {3.404591797204246*^9, 3.404591818684025*^9}, 
   3.404591857676158*^9, 3.404591891275168*^9, 3.4045919244095287`*^9, {
   3.404591965076082*^9, 3.404591974122978*^9}, 3.404592062926785*^9, {
   3.404592126197578*^9, 3.4045921337934437`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation 2", "Section",
 CellChangeTimes->{{3.4045925252719927`*^9, 3.404592556522622*^9}, {
  3.4045928290327682`*^9, 3.404592829115444*^9}}],

Cell["\<\
This equation explores using an arctangent as a means by which compatibility \
coefficients in below middle range get less emphasis than those at  the high \
end.\
\>", "Text",
 CellChangeTimes->{{3.4045925599648743`*^9, 3.40459257576026*^9}, {
  3.404592645374165*^9, 3.404592652743182*^9}, {3.404592693365768*^9, 
  3.404592704977071*^9}, {3.40459275289316*^9, 3.404592801907517*^9}, {
  3.404592833287444*^9, 3.4045928751674633`*^9}, {3.4045991928579617`*^9, 
  3.4045991945337057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{
   FractionBox["\[Pi]", "4"], 
   RowBox[{"ArcTan", "[", 
    RowBox[{"\[Pi]", "*", "x"}], "]"}], "*", "x"}]}]], "Input",
 CellChangeTimes->{{3.4045920710728493`*^9, 3.404592097590724*^9}, 
   3.404592163078128*^9, 3.4045922375980797`*^9, {3.404592341223124*^9, 
   3.404592374115223*^9}, {3.404592415729063*^9, 3.404592434515451*^9}, {
   3.4045980595411987`*^9, 3.404598060153675*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", "\[Pi]", " ", "x", " ", 
  RowBox[{"ArcTan", "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.404592098909747*^9, {3.4045921462837477`*^9, 3.404592163949123*^9}, 
   3.4045922427166433`*^9, {3.404592354134493*^9, 3.404592374625465*^9}, {
   3.404592417412199*^9, 3.4045924351569643`*^9}, 3.40459806096554*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"y", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "0"}], ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.404590153274328*^9, 3.404590169399311*^9}, {
   3.404590200979073*^9, 3.404590203442346*^9}, {3.404590242183119*^9, 
   3.404590247214078*^9}, {3.404590543289835*^9, 3.4045905433580112`*^9}, {
   3.4045921225266237`*^9, 3.404592125613811*^9}, 3.404592168120077*^9, {
   3.404592227819216*^9, 3.404592292665275*^9}, {3.404592329809943*^9, 
   3.404592361435288*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyHc81YsDxnGJ0rhG27GSVRGSlStPRVeJdDJK3CMjXZKdeSPjFJnFtVdW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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{491., Automatic},
  PlotRange->{{0, 1}, {0., 0.9916651027950589}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.4045921522142553`*^9, {3.404592228692836*^9, 3.404592296843809*^9}, {
   3.404592336955453*^9, 3.40459238108984*^9}, {3.404592420431409*^9, 
   3.404592436890272*^9}, 3.404598064283978*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation 3", "Section",
 CellChangeTimes->{{3.4045925252719927`*^9, 3.404592556522622*^9}, {
  3.404599119285574*^9, 3.404599119351038*^9}}],

Cell["\<\
This equation explores using the inverse of the Gausian function in 2 \
dimentions as a means by which compatibility coefficients in the upper and \
lower ranges get more emphasis than those in the middle.\
\>", "Text",
 CellChangeTimes->{{3.4045925599648743`*^9, 3.40459257576026*^9}, {
  3.404592645374165*^9, 3.404592652743182*^9}, {3.404592693365768*^9, 
  3.404592704977071*^9}, {3.40459275289316*^9, 3.404592801907517*^9}, {
  3.404599137781383*^9, 3.404599171302601*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"y", " ", "=", " ", 
   RowBox[{"1", " ", "-", " ", 
    RowBox[{"c1", 
     FractionBox["1", 
      RowBox[{"\[Sigma]", 
       SqrtBox[
        RowBox[{"2", "\[Pi]"}]]}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
        RowBox[{"2", "c2", 
         SuperscriptBox[
          RowBox[{"(", "\[Sigma]", ")"}], 
          RowBox[{"2", "\[IndentingNewLine]"}]]}]]}]]}]}]}],
  FontSize->24]], "Input",
 CellChangeTimes->{{3.4045899131413107`*^9, 3.404590018130765*^9}, 
   3.4045902251526823`*^9, {3.404590263426255*^9, 3.4045902636962023`*^9}, 
   3.404590343414065*^9, {3.404590387009807*^9, 3.404590404725469*^9}, {
   3.404590435955467*^9, 3.40459048105829*^9}, {3.404590567382167*^9, 
   3.4045906318545218`*^9}, {3.4045906775392103`*^9, 
   3.4045907022195663`*^9}, {3.404590822096949*^9, 3.4045908249716587`*^9}, {
   3.40459095496454*^9, 3.4045909614200993`*^9}, {3.404591934593738*^9, 
   3.404591941881975*^9}, {3.4045927190764713`*^9, 3.40459272111025*^9}, {
   3.4045991154151373`*^9, 3.404599116066436*^9}},
 FontSize->14],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"c1", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
       RowBox[{"2", " ", "c2", " ", 
        SuperscriptBox["\[Sigma]", "2"]}]]}]]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]}]], "Output",
 CellChangeTimes->{
  3.404590610790729*^9, 3.404590642463513*^9, 3.404590704166003*^9, 
   3.404590833180179*^9, 3.404590962078155*^9, 3.404591133788857*^9, 
   3.404591298058092*^9, {3.404591366488064*^9, 3.4045913893295193`*^9}, 
   3.404591533217491*^9, 3.404591792824336*^9, 3.404591854026661*^9, 
   3.404591885866185*^9, 3.4045919199616537`*^9, {3.404591961843623*^9, 
   3.4045919730002413`*^9}, 3.404592058837612*^9, 3.404592130350133*^9, 
   3.404592721876026*^9, 3.4045991234275093`*^9},
 FontSize->14]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"c1", "=", ".5"}], "\[IndentingNewLine]", 
 RowBox[{"c2", "=", ".25"}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]", "=", ".2"}], "\[IndentingNewLine]", 
 RowBox[{"\[Mu]", "=", ".5"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.404590030229046*^9, 3.4045902270164223`*^9, {3.404590273546677*^9, 
   3.404590331264193*^9}, {3.404590497451509*^9, 3.4045905239408503`*^9}, 
   3.4045906381164227`*^9, {3.404590707642593*^9, 3.4045907138072567`*^9}, {
   3.4045907445668783`*^9, 3.4045907475683537`*^9}, {3.404590909624385*^9, 
   3.4045909388294897`*^9}, {3.404591032050804*^9, 3.404591034544088*^9}, 
   3.404591099008032*^9, {3.4045913459919863`*^9, 3.404591346733129*^9}, 
   3.404591522596305*^9, {3.404591607045126*^9, 3.404591609846302*^9}, {
   3.404591781905992*^9, 3.404591783782247*^9}, {3.4045918435318623`*^9, 
   3.4045918455222397`*^9}, {3.404591882075845*^9, 3.404591915025386*^9}, {
   3.404591946805565*^9, 3.404591949720294*^9}}],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060646064*^9, 3.4045991250039053`*^9}],

Cell[BoxData["0.25`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060646064*^9, 3.4045991250163507`*^9}],

Cell[BoxData["0.2`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060646064*^9, 3.404599125018505*^9}],

Cell[BoxData["0.5`"], "Output",
 CellChangeTimes->{3.404591361738061*^9, 3.4045915246847486`*^9, 
  3.40459161126858*^9, 3.404591784292118*^9, 3.4045918460433817`*^9, 
  3.404591883441635*^9, 3.404591916659425*^9, 3.404591951534903*^9, 
  3.404592060646064*^9, 3.4045991250204763`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"y", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "0"}], ",", " ", "1."}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.404590153274328*^9, 3.404590169399311*^9}, {
  3.404590200979073*^9, 3.404590203442346*^9}, {3.404590242183119*^9, 
  3.404590247214078*^9}, {3.404590543289835*^9, 3.4045905433580112`*^9}, {
  3.4045921225266237`*^9, 3.404592125613811*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12nc8lt//B3CUiD52hZQikpAkGvImGlZRFCWRlZFNZpIZ0SArZK/I3kJ2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{530., Automatic},
  PlotRange->{{0, 1.}, {0., 0.9999962831974205}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.404590172042761*^9, 3.404590204208187*^9, {3.404590235718945*^9, 
   3.404590247846108*^9}, 3.40459045359381*^9, {3.404590511284226*^9, 
   3.4045905736359453`*^9}, 3.404590616057582*^9, 3.404590648794223*^9, 
   3.4045907179598627`*^9, 3.404590754860753*^9, 3.4045908401675653`*^9, {
   3.404590924410165*^9, 3.404590966762342*^9}, 3.4045910385385303`*^9, 
   3.404591103786969*^9, 3.4045911431998158`*^9, 3.404591226559553*^9, 
   3.404591300714115*^9, 3.404591370567541*^9, 3.40459141835938*^9, 
   3.4045915398720417`*^9, {3.404591797204246*^9, 3.404591818684025*^9}, 
   3.404591857676158*^9, 3.404591891275168*^9, 3.4045919244095287`*^9, {
   3.404591965076082*^9, 3.404591974122978*^9}, 3.404592062926785*^9, {
   3.404592126197578*^9, 3.4045921337934437`*^9}, 3.404599127124655*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1012, 945},
WindowMargins->{{182, Automatic}, {Automatic, 35}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (June 19, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> 
     FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", CharacterEncoding -> 
       "UTF-8"]]], 
   Cell[
    StyleData["Section"], FontColor -> GrayLevel[0]]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Mac OS X x86 (32-bit) (June 19, 2007)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 162, 5, 113, "Title"],
Cell[CellGroupData[{
Cell[777, 32, 97, 1, 72, "Section"],
Cell[877, 35, 478, 8, 41, "Text"],
Cell[CellGroupData[{
Cell[1380, 47, 1106, 27, 106, "Input"],
Cell[2489, 76, 762, 17, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3288, 98, 983, 15, 98, "Input"],
Cell[4274, 115, 261, 4, 37, "Output"],
Cell[4538, 121, 262, 4, 37, "Output"],
Cell[4803, 127, 261, 4, 37, "Output"],
Cell[5067, 133, 260, 4, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5364, 142, 439, 9, 37, "Input"],
Cell[5806, 153, 16340, 273, 357, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22195, 432, 148, 2, 72, "Section"],
Cell[22346, 436, 500, 9, 26, "Text"],
Cell[CellGroupData[{
Cell[22871, 449, 432, 9, 54, "Input"],
Cell[23306, 460, 396, 8, 54, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23739, 473, 563, 11, 37, "Input"],
Cell[24305, 486, 3768, 69, 335, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28122, 561, 146, 2, 72, "Section"],
Cell[28271, 565, 488, 8, 41, "Text"],
Cell[CellGroupData[{
Cell[28784, 577, 1207, 29, 106, "Input"],
Cell[29994, 608, 939, 23, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30970, 636, 983, 15, 98, "Input"],
Cell[31956, 653, 285, 4, 37, "Output"],
Cell[32244, 659, 286, 4, 37, "Output"],
Cell[32533, 665, 283, 4, 37, "Output"],
Cell[32819, 671, 285, 4, 37, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33141, 680, 439, 9, 37, "Input"],
Cell[33583, 691, 15451, 258, 357, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
