(ns play
  (:require [tick.alpha.api :as t :refer-macros [with-clock]]
            [tick.interval :as ti]
            [tick.format :as f]))

#_(:clj [
           [clj-time.core :as ct]
           [java-time :as j]])

(t/date "2017-01-20")

(with-clock (t/<< (t/clock (t/now)) (t/new-duration 1 :hours))
  (t/now)
  )
(comment

  (f/format :iso-local-date (t/today))

  (take 3 (iterate #(t/>> % (t/new-period 1 :years)) (t/date "1978-12-14")))

  ;;;;;;;;;;;;;;;;;;;;; construct/coerce ;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
  ; zproto - ICoercions - date, time... & about 40
  ; all fn names are singular
  ; mostly accept a string in place of a date - it will get parsed
  
  (t/date "2017-01-20")
  (t/date-time "2016-12-12T11:30")
  (t/offset-date-time "2018-05-01T11:30+05:00")
  (t/zoned-date-time "2017-12-15T12:00:00Z[America/New_York]")
  (t/millisecond (t/now))
  (t/day-of-month "2017-03-06")
  (t/inst (java.util.Date.))

  ; zproto - ITimeReify - on, at, in
  (-> (t/time "8pm") 
      (t/on "2018-02-14") 
      (t/in "America/New_York")
      (t/in "Europe/London")
      )
  
  (-> (t/date "2023-12-12")
      (t/at "12:00")
      (t/in "Europe/London"))
  
  (t/noon)
  (t/midnight)
  (t/now)
  (t/today)
  (t/date-time)

  ;truncation
  (t/truncate (t/now) :minutes)
  (t/truncate (t/now) :hours)

  ;fields
  (get t/unit-map :minutes)
  (keys (t/fields (t/today)))
  (:day-of-month (t/fields (t/today)))
  

  ;;;;;;;;;;;;;;;;;;;;;;; ;clocks ;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; zproto - IClock - make clock
  ; a clock ticks along (unless a fixedClock)
  
  ; it has a time zone, so will adjust for DST as necessary
  
  ; now, today and zone all use *clock* if bound
  ; they call the method on the clock, otherwise there is a static fn on the Instant/LocalDate etc that uses system current
  (t/clock)

  (t/with-clock (-> (t/clock) (t/in "America/New_York"))
    (t/zone))

  ; fixed clock - doesnt tick
  (t/clock (t/now))

  (def derefable-clock (t/atom))
  
  @derefable-clock
  
  ;;;;;;;;;durations and periods ;;;;;;;;;;;
  ;proto fns - all plural 
  ; periods work with local-date, durations work with ms-level dates
  
  ; zproto - IDuration - days, hours and down
  (t/micros (t/new-duration 1 :seconds))

  ; zproto - IPeriod - weeks, months, years
  ; periods minimum unit is a day
  ; unlike durations they account for dst
  (t/new-period 2 :days)
  (t/new-period 1 :weeks)

  ; get units of period/duration as map
  ;note, duration just has seconds and nanos units
  (t/units (t/+ (t/new-duration 1 :hours) (t/new-duration 2 :minutes) (t/new-duration 3 :seconds)))
  (t/units (t/+ (t/new-period 1 :years) (t/new-period 3 :months)))
  
  ;; DST
  ; advance period and time remains the same
  (t/>>  (t/zoned-date-time "2018-10-20T12:00:13Z[Europe/London]") (t/period 20 :days))
  
  ; advance a duration and time changes because dst change
  (t/>> (t/zoned-date-time "2018-10-20T12:00:13Z[Europe/London]") (t/days 20))
  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;; operations ;;;;;;;;;;;;;;;;;;;;;;;
  
  ; zproto - ITimeArithmetic - + -
  (t/+ (t/minutes 2) (t/seconds 3))
  (t/- (t/period 2 :years) (t/period 2 :years))
  ; zproto - ITimeShift - forward-number, forward-duration
  (t/>> (t/today) 1) ; do to local, year, year-month
  (t/>> (t/now) (t/seconds 5))
  ; equivalent to the above
  (t/+ (t/now) (t/seconds 5))
  
  ;max, min
  (t/max (t/date "2018-01-01") (t/date "2018-01-02") )

  ;;;;;;;;;;;;;;;;;;; not periods - adjusters, accessors ?? ;;;;;;;;;;;;;;;;;;;;
  
  ; have an ambient value, or can set it
  (t/day)
  (t/month)
  
  ; comparable before/after
  (t/year-month)

  ;;;;;;;;;;;;;;;; Other ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; zproto - ITimeSpan - beginning, end
  ; time spans (note: beginning and end will be used in interval construction)
  (t/beginning (t/now))

  ; last day of current month - + 1ms
  (t/end (t/year-month))
  
  ; other protocols
  
  ; zproto - ITimeComparison <, <=
  ; zproto - ITimeRangeable - range of dates starting from a point going forward
  ; zproto - IDivisible - divide - year month into localdates in that month etc
  ; zproto - MinMax - max possible value for a type. e.g. biggest instant that can be represented
  
  
  
  ;;;;;;;;;;;;;;;;;;;;; intervals ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; IIntervalOps
  ; IGroupable group-by

  (ti/contains?
    (t/interval (t/today) (t/+ (t/today) (t/period 2 :days )))
    (t/+ (t/today) (t/period 1 :days )))
  
  


  
  

  )