/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.tools;

import com.pinterest.secor.util.FileUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class LogFilePrinter {
    private boolean mPrintOffsetsOnly;

    public LogFilePrinter(boolean printOffsetsOnly) throws IOException {
        this.mPrintOffsetsOnly = printOffsetsOnly;
    }

    public void printFile(String path) throws Exception {
        FileSystem fileSystem = FileUtil.getFileSystem(path);
        Path fsPath = new Path(path);
        SequenceFile.Reader reader = new SequenceFile.Reader(fileSystem, fsPath, new Configuration());
        LongWritable key = (LongWritable)reader.getKeyClass().newInstance();
        BytesWritable value = (BytesWritable)reader.getValueClass().newInstance();
        System.out.println("reading file " + path);
        while (reader.next((Writable)key, (Writable)value)) {
            if (this.mPrintOffsetsOnly) {
                System.out.println(Long.toString(key.get()));
                continue;
            }
            byte[] nonPaddedBytes = new byte[value.getLength()];
            System.arraycopy(value.getBytes(), 0, nonPaddedBytes, 0, value.getLength());
            System.out.println(Long.toString(key.get()) + ": " + new String(nonPaddedBytes));
        }
    }
}

