/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.TimestampedMessageParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMessageParser
extends TimestampedMessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMessageParser.class);
    private final Pattern mTsPattern;

    public RegexMessageParser(SecorConfig config) {
        super(config);
        String patStr = config.getMessageTimestampInputPattern();
        LOG.info("timestamp pattern: {}", (Object)patStr);
        this.mTsPattern = Pattern.compile(patStr, 1);
    }

    @Override
    public long extractTimestampMillis(Message message) {
        String tsValue;
        String line = new String(message.getPayload());
        Matcher m = this.mTsPattern.matcher(line);
        if (m.find() && (tsValue = m.group(1)) != null) {
            return RegexMessageParser.toMillis(Long.parseLong(tsValue));
        }
        throw new NumberFormatException("Cannot find timestamp field in: " + line);
    }
}

