/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.message.ParsedMessage;
import java.util.regex.Pattern;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageParser {
    protected SecorConfig mConfig;
    protected String[] mNestedFields;
    private static final Logger LOG = LoggerFactory.getLogger(MessageParser.class);

    public MessageParser(SecorConfig config) {
        this.mConfig = config;
        if (this.mConfig.getMessageTimestampName() != null && !this.mConfig.getMessageTimestampName().isEmpty() && this.mConfig.getMessageTimestampNameSeparator() != null && !this.mConfig.getMessageTimestampNameSeparator().isEmpty()) {
            String separatorPattern = Pattern.quote(this.mConfig.getMessageTimestampNameSeparator());
            this.mNestedFields = this.mConfig.getMessageTimestampName().split(separatorPattern);
        }
    }

    public ParsedMessage parse(Message message) throws Exception {
        String[] partitions = this.extractPartitions(message);
        return new ParsedMessage(message.getTopic(), message.getKafkaPartition(), message.getOffset(), message.getKafkaKey(), message.getPayload(), partitions);
    }

    public abstract String[] extractPartitions(Message var1) throws Exception;

    public Object getJsonFieldValue(JSONObject jsonObject) {
        Object fieldValue = null;
        if (this.mNestedFields != null) {
            Object finalValue = null;
            for (int i = 0; i < this.mNestedFields.length; ++i) {
                if (!jsonObject.containsKey((Object)this.mNestedFields[i])) {
                    LOG.warn("Could not find key {} in message", (Object)this.mConfig.getMessageTimestampName());
                    break;
                }
                if (i < this.mNestedFields.length - 1) {
                    jsonObject = (JSONObject)jsonObject.get((Object)this.mNestedFields[i]);
                    continue;
                }
                finalValue = jsonObject.get((Object)this.mNestedFields[i]);
            }
            fieldValue = finalValue;
        } else {
            fieldValue = jsonObject.get((Object)this.mConfig.getMessageTimestampName());
        }
        return fieldValue;
    }
}

