/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.TimestampedMessageParser;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class JsonMessageParser
extends TimestampedMessageParser {
    private final boolean m_timestampRequired;

    public JsonMessageParser(SecorConfig config) {
        super(config);
        this.m_timestampRequired = config.isMessageTimestampRequired();
    }

    @Override
    public long extractTimestampMillis(Message message) {
        JSONObject jsonObject = (JSONObject)JSONValue.parse((byte[])message.getPayload());
        if (jsonObject != null) {
            Object fieldValue = this.getJsonFieldValue(jsonObject);
            if (fieldValue != null) {
                return JsonMessageParser.toMillis(Double.valueOf(fieldValue.toString()).longValue());
            }
        } else if (this.m_timestampRequired) {
            throw new RuntimeException("Missing timestamp field for message: " + message);
        }
        return 0L;
    }
}

