/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.uploader;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.uploader.Handle;
import com.pinterest.secor.uploader.S3UploadHandle;
import com.pinterest.secor.uploader.UploadManager;
import com.pinterest.secor.util.FileUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3UploadManager
extends UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3UploadManager.class);
    private static final String KMS = "KMS";
    private static final String S3 = "S3";
    private static final String CUSTOMER = "customer";
    private final String s3Path;
    private TransferManager mManager;

    public S3UploadManager(SecorConfig config) {
        super(config);
        final String accessKey = this.mConfig.getAwsAccessKey();
        final String secretKey = this.mConfig.getAwsSecretKey();
        String endpoint = this.mConfig.getAwsEndpoint();
        String region = this.mConfig.getAwsRegion();
        String awsRole = this.mConfig.getAwsRole();
        this.s3Path = this.mConfig.getS3Path();
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        boolean isHttpProxyEnabled = this.mConfig.getAwsProxyEnabled();
        if (isHttpProxyEnabled) {
            LOG.info("Http Proxy Enabled for S3UploadManager");
            String httpProxyHost = this.mConfig.getAwsProxyHttpHost();
            int httpProxyPort = this.mConfig.getAwsProxyHttpPort();
            clientConfiguration.setProxyHost(httpProxyHost);
            clientConfiguration.setProxyPort(httpProxyPort);
        }
        Object provider = accessKey.isEmpty() || secretKey.isEmpty() ? new DefaultAWSCredentialsProviderChain() : new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(accessKey, secretKey);
            }

            public void refresh() {
            }
        };
        if (!awsRole.isEmpty()) {
            provider = new STSAssumeRoleSessionCredentialsProvider((AWSCredentialsProvider)provider, awsRole, "secor");
        }
        AmazonS3Client client = new AmazonS3Client((AWSCredentialsProvider)provider, clientConfiguration);
        if (!endpoint.isEmpty()) {
            client.setEndpoint(endpoint);
        } else if (!region.isEmpty()) {
            client.setRegion(Region.getRegion((Regions)Regions.fromName((String)region)));
        }
        this.mManager = new TransferManager((AmazonS3)client);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Handle<?> upload(LogFilePath localPath) throws Exception {
        String s3Key;
        String s3Bucket = this.mConfig.getS3Bucket();
        String curS3Path = this.s3Path;
        File localFile = new File(localPath.getLogFilePath());
        if (FileUtil.s3PathPrefixIsAltered(localPath.withPrefix(curS3Path).getLogFilePath(), this.mConfig)) {
            curS3Path = FileUtil.getS3AlternativePathPrefix(this.mConfig);
            LOG.info("Will upload file {} to alternative s3 path s3://{}/{}", new Object[]{localFile, s3Bucket, curS3Path});
        }
        if (this.mConfig.getS3MD5HashPrefix()) {
            String md5Hash = FileUtil.getMd5Hash(localPath.getTopic(), localPath.getPartitions());
            s3Key = localPath.withPrefix(md5Hash + "/" + curS3Path).getLogFilePath();
        } else {
            s3Key = localPath.withPrefix(curS3Path).getLogFilePath();
        }
        PutObjectRequest uploadRequest = new PutObjectRequest(s3Bucket, s3Key, localFile);
        if (!this.mConfig.getAwsSseType().isEmpty()) {
            if (S3.equals(this.mConfig.getAwsSseType())) {
                LOG.info("uploading file {} to s3://{}/{} with S3-managed encryption", new Object[]{localFile, s3Bucket, s3Key});
                this.enableS3Encryption(uploadRequest);
            } else if (KMS.equals(this.mConfig.getAwsSseType())) {
                LOG.info("uploading file {} to s3://{}/{} using KMS based encryption", new Object[]{localFile, s3Bucket, s3Key});
                this.enableKmsEncryption(uploadRequest);
            } else {
                if (!CUSTOMER.equals(this.mConfig.getAwsSseType())) throw new IllegalArgumentException(this.mConfig.getAwsSseType() + "is not a suitable type for AWS SSE encryption");
                LOG.info("uploading file {} to s3://{}/{} using customer key encryption", new Object[]{localFile, s3Bucket, s3Key});
                this.enableCustomerEncryption(uploadRequest);
            }
        } else {
            LOG.info("uploading file {} to s3://{}/{} with no encryption", new Object[]{localFile, s3Bucket, s3Key});
        }
        Upload upload = this.mManager.upload(uploadRequest);
        return new S3UploadHandle(upload);
    }

    private void enableCustomerEncryption(PutObjectRequest uploadRequest) {
        SSECustomerKey sseKey = new SSECustomerKey(this.mConfig.getAwsSseCustomerKey());
        uploadRequest.withSSECustomerKey(sseKey);
    }

    private void enableKmsEncryption(PutObjectRequest uploadRequest) {
        String keyId = this.mConfig.getAwsSseKmsKey();
        if (!keyId.isEmpty()) {
            uploadRequest.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(keyId));
        } else {
            uploadRequest.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams());
        }
    }

    private void enableS3Encryption(PutObjectRequest uploadRequest) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        uploadRequest.setMetadata(objectMetadata);
    }
}

