/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.uploader;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.uploader.FutureHandle;
import com.pinterest.secor.uploader.Handle;
import com.pinterest.secor.uploader.UploadManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureUploadManager
extends UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(AzureUploadManager.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(256);
    private CloudBlobClient blobClient;

    public AzureUploadManager(SecorConfig config) throws Exception {
        super(config);
        if (this.mConfig.getAzureAccountKey().isEmpty()) {
            URI storageURI = new URI(this.mConfig.getAzureBaseURI());
            StorageCredentialsSharedAccessSignature sharedAccessSignature = new StorageCredentialsSharedAccessSignature(this.mConfig.getAzureSASKey());
            this.blobClient = new CloudBlobClient(storageURI, (StorageCredentials)sharedAccessSignature);
        } else {
            String storageConnectionString = "DefaultEndpointsProtocol=" + this.mConfig.getAzureEndpointsProtocol() + ";" + "AccountName=" + this.mConfig.getAzureAccountName() + ";" + "AccountKey=" + this.mConfig.getAzureAccountKey() + ";";
            CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)storageConnectionString);
            this.blobClient = storageAccount.createCloudBlobClient();
        }
    }

    @Override
    public Handle<?> upload(LogFilePath localPath) throws Exception {
        final String azureContainer = this.mConfig.getAzureContainer();
        final String azureKey = localPath.withPrefix(this.mConfig.getAzurePath()).getLogFilePath();
        final File localFile = new File(localPath.getLogFilePath());
        LOG.info("uploading file {} to azure://{}/{}", new Object[]{localFile, azureContainer, azureKey});
        Future<?> f = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CloudBlobContainer container = AzureUploadManager.this.blobClient.getContainerReference(azureContainer);
                    if (container == null) {
                        container.createIfNotExists();
                    }
                    CloudBlockBlob blob = container.getBlockBlobReference(azureKey);
                    blob.upload((InputStream)new FileInputStream(localFile), localFile.length());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                catch (StorageException e) {
                    throw new RuntimeException(e);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return new FutureHandle(f);
    }
}

