/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.MessageParser;
import com.pinterest.secor.parser.Partitioner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimestampedMessageParser
extends MessageParser
implements Partitioner {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampedMessageParser.class);
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private final SimpleDateFormat mDtFormatter;
    private final SimpleDateFormat mHrFormatter;
    private final SimpleDateFormat mDtHrFormatter;
    private final int mFinalizerDelaySeconds;
    private final SimpleDateFormat mDtHrMinFormatter;
    private final SimpleDateFormat mMinFormatter;
    private final boolean mUsingHourly;
    private final boolean mUsingMinutely;

    public TimestampedMessageParser(SecorConfig config) {
        super(config);
        this.mUsingHourly = TimestampedMessageParser.usingHourly(config);
        this.mUsingMinutely = TimestampedMessageParser.usingMinutely(config);
        LOG.info("UsingHourly: {}", (Object)this.mUsingHourly);
        LOG.info("UsingMin: {}", (Object)this.mUsingMinutely);
        this.mFinalizerDelaySeconds = config.getFinalizerDelaySeconds();
        LOG.info("FinalizerDelaySeconds: {}", (Object)this.mFinalizerDelaySeconds);
        this.mDtFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.mDtFormatter.setTimeZone(config.getTimeZone());
        this.mHrFormatter = new SimpleDateFormat("HH");
        this.mHrFormatter.setTimeZone(config.getTimeZone());
        this.mDtHrFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
        this.mDtHrFormatter.setTimeZone(config.getTimeZone());
        this.mDtHrMinFormatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        this.mDtHrMinFormatter.setTimeZone(config.getTimeZone());
        this.mMinFormatter = new SimpleDateFormat("mm");
        this.mMinFormatter.setTimeZone(config.getTimeZone());
    }

    static boolean usingHourly(SecorConfig config) {
        return config.getBoolean("partitioner.granularity.hour", false);
    }

    static boolean usingMinutely(SecorConfig config) {
        return config.getBoolean("partitioner.granularity.minute", false);
    }

    protected static long toMillis(long timestamp) {
        long nanosecondDivider = (long)Math.pow(10.0, 18.0);
        long millisecondDivider = (long)Math.pow(10.0, 12.0);
        long timestampMillis = timestamp / nanosecondDivider > 0L ? timestamp / (long)Math.pow(10.0, 6.0) : (timestamp / millisecondDivider > 0L ? timestamp : timestamp * 1000L);
        return timestampMillis;
    }

    public abstract long extractTimestampMillis(Message var1) throws Exception;

    protected String[] generatePartitions(long timestampMillis, boolean usingHourly, boolean usingMinutely) throws Exception {
        Date date = new Date(timestampMillis);
        String dt = "dt=" + this.mDtFormatter.format(date);
        String hr = "hr=" + this.mHrFormatter.format(date);
        String min = "min=" + this.mMinFormatter.format(date);
        if (usingMinutely) {
            return new String[]{dt, hr, min};
        }
        if (usingHourly) {
            return new String[]{dt, hr};
        }
        return new String[]{dt};
    }

    protected long parsePartitions(String[] partitions) throws Exception {
        String dtValue = partitions[0].split("=")[1];
        String hrValue = partitions.length > 1 ? partitions[1].split("=")[1] : "00";
        String minValue = partitions.length > 2 ? partitions[2].split("=")[1] : "00";
        String value = dtValue + "-" + hrValue + "-" + minValue;
        Date date = this.mDtHrMinFormatter.parse(value);
        return date.getTime();
    }

    @Override
    public String[] extractPartitions(Message message) throws Exception {
        long timestampMillis = this.extractTimestampMillis(message);
        return this.generatePartitions(timestampMillis, this.mUsingHourly, this.mUsingMinutely);
    }

    private long getFinalizedTimestampMillis(Message lastMessage, Message committedMessage) throws Exception {
        long lastTimestamp = this.extractTimestampMillis(lastMessage);
        long committedTimestamp = this.extractTimestampMillis(committedMessage);
        long now = System.currentTimeMillis();
        if (lastTimestamp == committedTimestamp && now - lastTimestamp > (long)(this.mFinalizerDelaySeconds * 1000)) {
            LOG.info("No new message coming, use the current time: " + now);
            return now;
        }
        return committedTimestamp;
    }

    @Override
    public String[] getFinalizedUptoPartitions(List<Message> lastMessages, List<Message> committedMessages) throws Exception {
        if (lastMessages == null || committedMessages == null) {
            LOG.error("Either: {} and {} is null", lastMessages, committedMessages);
            return null;
        }
        assert (lastMessages.size() == committedMessages.size());
        long minMillis = Long.MAX_VALUE;
        for (int i = 0; i < lastMessages.size(); ++i) {
            long millis = this.getFinalizedTimestampMillis(lastMessages.get(i), committedMessages.get(i));
            if (millis >= minMillis) continue;
            LOG.info("partition {}, time {}", (Object)i, (Object)millis);
            minMillis = millis;
        }
        if (minMillis == Long.MAX_VALUE) {
            LOG.error("No valid timestamps among messages: {} and {}", lastMessages, committedMessages);
            return null;
        }
        LOG.info("adjusted millis {}", (Object)(minMillis -= (long)this.mFinalizerDelaySeconds * 1000L));
        return this.generatePartitions(minMillis, this.mUsingHourly, this.mUsingMinutely);
    }

    @Override
    public String[] getPreviousPartitions(String[] partitions) throws Exception {
        long millis = this.parsePartitions(partitions);
        boolean usingHourly = this.mUsingHourly;
        boolean usingMinutely = this.mUsingMinutely;
        if (this.mUsingMinutely && millis % 3600000L == 0L) {
            if (partitions.length == 3) {
                usingMinutely = false;
                if (millis % 86400000L == 0L) {
                    millis -= 86400000L;
                } else {
                    millis -= 3600000L;
                    usingHourly = true;
                }
            } else if (partitions.length == 2) {
                millis += 3600000L;
                millis -= 60000L;
                usingMinutely = true;
            } else {
                millis += 86400000L;
                millis -= 3600000L;
                usingMinutely = false;
                usingHourly = true;
            }
        } else if (this.mUsingHourly && millis % 86400000L == 0L) {
            if (partitions.length == 2) {
                usingHourly = false;
                millis -= 86400000L;
            } else {
                usingHourly = true;
                millis += 86400000L;
                millis -= 3600000L;
            }
        } else {
            long delta;
            long l = delta = this.mUsingHourly ? 3600000L : 86400000L;
            if (this.mUsingMinutely) {
                delta = 60000L;
            }
            millis -= delta;
        }
        return this.generatePartitions(millis, usingHourly, usingMinutely);
    }
}

