/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class QuboleClient {
    private String mApiToken;

    public QuboleClient(SecorConfig config) {
        this.mApiToken = config.getQuboleApiToken();
    }

    private Map makeRequest(URL url, String body) throws IOException {
        HttpURLConnection connection = null;
        try {
            InputStream inputStream;
            BufferedReader reader;
            Object responseObj;
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("X-AUTH-TOKEN", this.mApiToken);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accepts", "application/json");
            connection.setRequestProperty("Accept", "*/*");
            if (body != null) {
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Length", Integer.toString(body.getBytes().length));
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (body != null) {
                DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.writeBytes(body);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            if (!((responseObj = JSONValue.parse((Reader)(reader = new BufferedReader(new InputStreamReader(inputStream = connection.getInputStream()))))) instanceof Map)) {
                throw new RuntimeException("command " + url + " body " + body + " unexpected " + responseObj);
            }
            Map response = (Map)responseObj;
            if (response.get("status").equals("error")) {
                throw new RuntimeException("command " + url + " with body " + body + " failed " + JSONObject.toJSONString((Map)response));
            }
            return response;
        }
        catch (IOException exception) {
            if (connection != null) {
                connection.disconnect();
            }
            throw exception;
        }
    }

    private int query(String query) throws IOException {
        URL url = new URL("https://api.qubole.com/api/v1.2/commands");
        JSONObject queryJson = new JSONObject();
        queryJson.put((Object)"query", (Object)query);
        String body = queryJson.toString();
        Map response = this.makeRequest(url, body);
        return (Integer)response.get("id");
    }

    private void waitForCompletion(int commandId) throws IOException, InterruptedException {
        URL url = new URL("https://api.qubole.com/api/v1.2/commands/" + commandId);
        Map response;
        while (!(response = this.makeRequest(url, null)).get("status").equals("done")) {
            System.out.println("waiting 3 seconds for results of query " + commandId + ". Current status " + response.get("status"));
            Thread.sleep(3000L);
        }
        return;
    }

    public void addPartition(String table, String partition) throws IOException, InterruptedException {
        String queryStr = "ALTER TABLE " + table + " ADD IF NOT EXISTS PARTITION (" + partition + ")";
        int commandId = this.query(queryStr);
        this.waitForCompletion(commandId);
    }
}

