/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.MessageParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMessageParser
extends MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(DateMessageParser.class);
    protected static final String defaultDate = "dt=1970-01-01";
    protected static final String defaultFormatter = "yyyy-MM-dd";
    protected SimpleDateFormat outputFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected Object inputPattern;
    protected SimpleDateFormat inputFormatter;

    public DateMessageParser(SecorConfig config) {
        super(config);
        TimeZone timeZone = config.getTimeZone();
        this.inputPattern = this.mConfig.getMessageTimestampInputPattern();
        this.inputFormatter = new SimpleDateFormat(this.inputPattern.toString());
        this.inputFormatter.setTimeZone(timeZone);
        this.outputFormatter.setTimeZone(timeZone);
    }

    @Override
    public String[] extractPartitions(Message message) {
        Object fieldValue;
        JSONObject jsonObject = (JSONObject)JSONValue.parse((byte[])message.getPayload());
        String[] result = new String[]{defaultDate};
        if (jsonObject != null && (fieldValue = this.getJsonFieldValue(jsonObject)) != null && this.inputPattern != null) {
            try {
                Date dateFormat = this.inputFormatter.parse(fieldValue.toString());
                result[0] = "dt=" + this.outputFormatter.format(dateFormat);
                return result;
            }
            catch (Exception e) {
                LOG.warn("Impossible to convert date = {} for the input pattern = {} . Using date default = {}", new Object[]{fieldValue.toString(), this.inputPattern.toString(), result[0]});
            }
        }
        return result;
    }
}

