/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.main;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.tools.LogFilePrinter;
import com.pinterest.secor.util.FileUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilePrinterMain {
    private static final Logger LOG = LoggerFactory.getLogger(LogFilePrinterMain.class);

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"sequence file to read");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<sequence_file_name>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"f"));
        options.addOption("o", "print_offsets_only", false, "whether to print only offsets ignoring the message payload");
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    public static void main(String[] args) {
        try {
            CommandLine commandLine = LogFilePrinterMain.parseArgs(args);
            SecorConfig config = SecorConfig.load();
            FileUtil.configure(config);
            LogFilePrinter printer = new LogFilePrinter(commandLine.hasOption("print_offsets_only"));
            printer.printFile(commandLine.getOptionValue("file"));
        }
        catch (Throwable t) {
            LOG.error("Log file printer failed", t);
            System.exit(1);
        }
    }
}

