/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import com.pinterest.secor.common.TopicPartition;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetTracker.class);
    private HashMap<TopicPartition, Long> mLastSeenOffset = new HashMap();
    private HashMap<TopicPartition, Long> mFirstSeendOffset;
    private HashMap<TopicPartition, Long> mCommittedOffsetCount = new HashMap();

    public OffsetTracker() {
        this.mFirstSeendOffset = new HashMap();
    }

    public long getLastSeenOffset(TopicPartition topicPartition) {
        Long offset = this.mLastSeenOffset.get(topicPartition);
        if (offset == null) {
            return -2L;
        }
        return offset;
    }

    public long setLastSeenOffset(TopicPartition topicPartition, long offset) {
        long lastSeenOffset = this.getLastSeenOffset(topicPartition);
        this.mLastSeenOffset.put(topicPartition, offset);
        if (lastSeenOffset + 1L != offset) {
            if (lastSeenOffset >= 0L) {
                LOG.warn("offset for topic {} partition {} changed from {} to {}", new Object[]{topicPartition.getTopic(), topicPartition.getPartition(), lastSeenOffset, offset});
            } else {
                LOG.info("starting to consume topic {} partition {} from offset {}", new Object[]{topicPartition.getTopic(), topicPartition.getPartition(), offset});
            }
        }
        if (this.mFirstSeendOffset.get(topicPartition) == null) {
            this.mFirstSeendOffset.put(topicPartition, offset);
        }
        return lastSeenOffset;
    }

    public long getTrueCommittedOffsetCount(TopicPartition topicPartition) {
        Long committedOffsetCount = this.mCommittedOffsetCount.get(topicPartition);
        if (committedOffsetCount == null) {
            return -1L;
        }
        return committedOffsetCount;
    }

    public long getAdjustedCommittedOffsetCount(TopicPartition topicPartition) {
        Long firstSeenOffset;
        long trueCommittedOffsetCount = this.getTrueCommittedOffsetCount(topicPartition);
        if (trueCommittedOffsetCount == -1L && (firstSeenOffset = this.mFirstSeendOffset.get(topicPartition)) != null) {
            return firstSeenOffset;
        }
        return trueCommittedOffsetCount;
    }

    public long setCommittedOffsetCount(TopicPartition topicPartition, long count) {
        long trueCommittedOffsetCount = this.getTrueCommittedOffsetCount(topicPartition);
        assert (trueCommittedOffsetCount <= count) : Long.toString(trueCommittedOffsetCount) + " <= " + count;
        this.mCommittedOffsetCount.put(topicPartition, count);
        return trueCommittedOffsetCount;
    }
}

