/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.util;

import com.pinterest.secor.common.SecorConfig;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileUtil {
    private static SecorConfig mConfig = null;

    public static void configure(SecorConfig config) {
        mConfig = config;
    }

    public static FileSystem getFileSystem(String path) throws IOException {
        Configuration conf = new Configuration();
        if (mConfig != null) {
            conf.set("fs.s3n.awsAccessKeyId", mConfig.getAwsAccessKey());
            conf.set("fs.s3n.awsSecretAccessKey", mConfig.getAwsSecretKey());
        }
        return FileSystem.get((URI)URI.create(path), (Configuration)conf);
    }

    public static String[] list(String path) throws IOException {
        FileSystem fs = FileUtil.getFileSystem(path);
        Path fsPath = new Path(path);
        ArrayList<String> paths = new ArrayList<String>();
        FileStatus[] statuses = fs.listStatus(fsPath);
        if (statuses != null) {
            for (FileStatus status : statuses) {
                Path statusPath = status.getPath();
                if (path.startsWith("s3://") || path.startsWith("s3n://")) {
                    paths.add(statusPath.toUri().toString());
                    continue;
                }
                paths.add(statusPath.toUri().getPath());
            }
        }
        return paths.toArray(new String[0]);
    }

    public static String[] listRecursively(String path) throws IOException {
        String[] directPaths;
        ArrayList<String> paths = new ArrayList<String>();
        for (String directPath : directPaths = FileUtil.list(path)) {
            if (directPath.equals(path)) {
                assert (directPaths.length == 1) : Integer.toString(directPaths.length) + " == 1";
                paths.add(directPath);
                continue;
            }
            String[] recursivePaths = FileUtil.listRecursively(directPath);
            paths.addAll(Arrays.asList(recursivePaths));
        }
        return paths.toArray(new String[0]);
    }

    public static boolean exists(String path) throws IOException {
        FileSystem fs = FileUtil.getFileSystem(path);
        Path fsPath = new Path(path);
        return fs.exists(fsPath);
    }

    public static void delete(String path) throws IOException {
        if (FileUtil.exists(path)) {
            Path fsPath = new Path(path);
            boolean success = FileUtil.getFileSystem(path).delete(fsPath, true);
            if (!success) {
                throw new IOException("Failed to delete " + path);
            }
        }
    }

    public static void moveToS3(String srcLocalPath, String dstS3Path) throws IOException {
        Path srcPath = new Path(srcLocalPath);
        Path dstPath = new Path(dstS3Path);
        FileUtil.getFileSystem(dstS3Path).moveFromLocalFile(srcPath, dstPath);
    }

    public static void touch(String path) throws IOException {
        FileSystem fs = FileUtil.getFileSystem(path);
        Path fsPath = new Path(path);
        fs.create(fsPath).close();
    }

    public static long getModificationTimeMsRecursive(String path) throws IOException {
        FileSystem fs = FileUtil.getFileSystem(path);
        Path fsPath = new Path(path);
        FileStatus status = fs.getFileStatus(fsPath);
        long modificationTime = status.getModificationTime();
        FileStatus[] statuses = fs.listStatus(fsPath);
        if (statuses != null) {
            for (FileStatus fileStatus : statuses) {
                Path statusPath = fileStatus.getPath();
                String stringPath = path.startsWith("s3://") || path.startsWith("s3n://") ? statusPath.toUri().toString() : statusPath.toUri().getPath();
                if (stringPath.equals(path)) continue;
                modificationTime = Math.max(modificationTime, FileUtil.getModificationTimeMsRecursive(stringPath));
            }
        }
        return modificationTime;
    }
}

