/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.main;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.tools.LogFileVerifier;
import com.pinterest.secor.util.FileUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileVerifierMain {
    private static final Logger LOG = LoggerFactory.getLogger(LogFileVerifierMain.class);

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"topic");
        OptionBuilder.withDescription((String)"kafka topic name");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<topic>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"start_offset");
        OptionBuilder.withDescription((String)"offset identifying the first set of files to check");
        OptionBuilder.withArgName((String)"<offset>");
        OptionBuilder.withType(Long.class);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"end_offset");
        OptionBuilder.withDescription((String)"offset identifying the last set of files to check");
        OptionBuilder.withArgName((String)"<offset>");
        OptionBuilder.withType(Long.class);
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"messages");
        OptionBuilder.withDescription((String)"expected number of messages");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<num_messages>");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"m"));
        options.addOption("q", "sequence_offsets", false, "whether to verify that offsets increase sequentially.  Requires loading all offsets in a snapshot to memory so use cautiously");
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    public static void main(String[] args) {
        try {
            CommandLine commandLine = LogFileVerifierMain.parseArgs(args);
            SecorConfig config = SecorConfig.load();
            FileUtil.configure(config);
            LogFileVerifier verifier = new LogFileVerifier(config, commandLine.getOptionValue("topic"));
            long startOffset = -2L;
            long endOffset = Long.MAX_VALUE;
            if (commandLine.hasOption("start_offset")) {
                startOffset = Long.parseLong(commandLine.getOptionValue("start_offset"));
                if (commandLine.hasOption("end_offset")) {
                    endOffset = Long.parseLong(commandLine.getOptionValue("end_offset"));
                }
            }
            int numMessages = -1;
            if (commandLine.hasOption("messages")) {
                numMessages = ((Number)commandLine.getParsedOptionValue("messages")).intValue();
            }
            verifier.verifyCounts(startOffset, endOffset, numMessages);
            if (commandLine.hasOption("sequence_offsets")) {
                verifier.verifySequences(startOffset, endOffset);
            }
            System.out.println("verification succeeded");
        }
        catch (Throwable t) {
            LOG.error("Log file verifier failed", t);
            System.exit(1);
        }
    }
}

