/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.MessageParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMessageParser
extends MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(DateMessageParser.class);
    protected static final String defaultDate = "dt=1970-01-01";
    protected static final String defaultFormatter = "yyyy-MM-dd";

    public DateMessageParser(SecorConfig config) {
        super(config);
    }

    @Override
    public String[] extractPartitions(Message message) {
        JSONObject jsonObject = (JSONObject)JSONValue.parse((byte[])message.getPayload());
        String[] result = new String[]{defaultDate};
        if (jsonObject != null) {
            Object fieldValue = jsonObject.get((Object)this.mConfig.getMessageTimestampName());
            String inputPattern = this.mConfig.getMessageTimestampInputPattern();
            if (fieldValue != null && inputPattern != null) {
                try {
                    SimpleDateFormat inputFormatter = new SimpleDateFormat(inputPattern.toString());
                    SimpleDateFormat outputFormatter = new SimpleDateFormat(defaultFormatter);
                    Date dateFormat = inputFormatter.parse(fieldValue.toString());
                    result[0] = "dt=" + outputFormatter.format(dateFormat);
                    return result;
                }
                catch (Exception e) {
                    LOG.warn("Impossible to convert date = " + fieldValue.toString() + " for the input pattern = " + inputPattern.toString() + ". Using date default=" + result[0]);
                }
            }
        }
        return result;
    }
}

