/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.main;

import com.pinterest.secor.common.OstrichAdminService;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.consumer.Consumer;
import com.pinterest.secor.tools.LogFileDeleter;
import com.pinterest.secor.util.FileUtil;
import com.pinterest.secor.util.RateLimitUtil;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerMain.class);

    public static void main(String[] args) {
        if (args.length != 0) {
            System.err.println("Usage: java -Dconfig=<secor_properties> -Dlog4j.configuration=<log4j_properties> ConsumerMain");
            return;
        }
        try {
            SecorConfig config = SecorConfig.load();
            OstrichAdminService ostrichService = new OstrichAdminService(config.getOstrichPort());
            ostrichService.start();
            FileUtil.configure(config);
            LogFileDeleter logFileDeleter = new LogFileDeleter(config);
            logFileDeleter.deleteOldLogs();
            RateLimitUtil.configure(config);
            Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable exception) {
                    LOG.error("Thread " + thread + " failed", exception);
                    System.exit(1);
                }
            };
            LOG.info("starting " + config.getConsumerThreads() + " consumer threads");
            LinkedList<Consumer> consumers = new LinkedList<Consumer>();
            for (int i = 0; i < config.getConsumerThreads(); ++i) {
                Consumer consumer = new Consumer(config);
                consumer.setUncaughtExceptionHandler(handler);
                consumers.add(consumer);
                consumer.start();
            }
            for (Consumer consumer : consumers) {
                consumer.join();
            }
        }
        catch (Throwable t) {
            LOG.error("Consumer failed", t);
            System.exit(1);
        }
    }
}

