/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.common.TopicPartition;
import com.pinterest.secor.io.FileReaderWriter;
import com.pinterest.secor.util.FileUtil;
import com.pinterest.secor.util.ReflectionUtil;
import com.pinterest.secor.util.StatsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(FileRegistry.class);
    private final SecorConfig mConfig;
    private HashMap<TopicPartition, HashSet<LogFilePath>> mFiles;
    private HashMap<LogFilePath, FileReaderWriter> mWriters;
    private HashMap<LogFilePath, Long> mCreationTimes;

    public FileRegistry(SecorConfig mConfig) {
        this.mConfig = mConfig;
        this.mFiles = new HashMap();
        this.mWriters = new HashMap();
        this.mCreationTimes = new HashMap();
    }

    public Collection<TopicPartition> getTopicPartitions() {
        Set<TopicPartition> topicPartitions = this.mFiles.keySet();
        if (topicPartitions == null) {
            return new HashSet<TopicPartition>();
        }
        return new HashSet<TopicPartition>(topicPartitions);
    }

    public Collection<LogFilePath> getPaths(TopicPartition topicPartition) {
        HashSet<LogFilePath> logFilePaths = this.mFiles.get(topicPartition);
        if (logFilePaths == null) {
            return new HashSet<LogFilePath>();
        }
        return new HashSet<LogFilePath>(logFilePaths);
    }

    public FileReaderWriter getOrCreateWriter(LogFilePath path, CompressionCodec codec) throws Exception {
        FileReaderWriter writer = this.mWriters.get(path);
        if (writer == null) {
            FileUtil.delete(path.getLogFilePath());
            FileUtil.delete(path.getLogFileCrcPath());
            TopicPartition topicPartition = new TopicPartition(path.getTopic(), path.getKafkaPartition());
            HashSet<LogFilePath> files = this.mFiles.get(topicPartition);
            if (files == null) {
                files = new HashSet();
                this.mFiles.put(topicPartition, files);
            }
            if (!files.contains(path)) {
                files.add(path);
            }
            writer = (FileReaderWriter)ReflectionUtil.createFileReaderWriter(this.mConfig.getFileReaderWriter(), path, codec, FileReaderWriter.Type.Writer);
            this.mWriters.put(path, writer);
            this.mCreationTimes.put(path, System.currentTimeMillis() / 1000L);
            LOG.debug("created writer for path " + path.getLogFilePath());
        }
        return writer;
    }

    public void deletePath(LogFilePath path) throws IOException {
        TopicPartition topicPartition = new TopicPartition(path.getTopic(), path.getKafkaPartition());
        HashSet<LogFilePath> paths = this.mFiles.get(topicPartition);
        paths.remove(path);
        if (paths.isEmpty()) {
            this.mFiles.remove(topicPartition);
            StatsUtil.clearLabel("secor.size." + topicPartition.getTopic() + "." + topicPartition.getPartition());
            StatsUtil.clearLabel("secor.modification_age_sec." + topicPartition.getTopic() + "." + topicPartition.getPartition());
        }
        this.deleteWriter(path);
        FileUtil.delete(path.getLogFilePath());
        FileUtil.delete(path.getLogFileCrcPath());
    }

    public void deleteTopicPartition(TopicPartition topicPartition) throws IOException {
        HashSet<LogFilePath> paths = this.mFiles.get(topicPartition);
        if (paths == null) {
            return;
        }
        HashSet clonedPaths = (HashSet)paths.clone();
        for (LogFilePath path : clonedPaths) {
            this.deletePath(path);
        }
    }

    public void deleteWriter(LogFilePath path) throws IOException {
        FileReaderWriter writer = this.mWriters.get(path);
        if (writer == null) {
            LOG.warn("No writer found for path " + path.getLogFilePath());
        } else {
            LOG.info("Deleting writer for path " + path.getLogFilePath());
            writer.close();
            this.mWriters.remove(path);
            this.mCreationTimes.remove(path);
        }
    }

    public void deleteWriters(TopicPartition topicPartition) throws IOException {
        HashSet<LogFilePath> paths = this.mFiles.get(topicPartition);
        if (paths == null) {
            LOG.warn("No paths found for topic " + topicPartition.getTopic() + " partition " + topicPartition.getPartition());
        } else {
            for (LogFilePath path : paths) {
                this.deleteWriter(path);
            }
        }
    }

    public long getSize(TopicPartition topicPartition) throws IOException {
        Collection<LogFilePath> paths = this.getPaths(topicPartition);
        long result = 0L;
        for (LogFilePath path : paths) {
            FileReaderWriter writer = this.mWriters.get(path);
            if (writer == null) continue;
            result += writer.getLength();
        }
        StatsUtil.setLabel("secor.size." + topicPartition.getTopic() + "." + topicPartition.getPartition(), Long.toString(result));
        return result;
    }

    public long getModificationAgeSec(TopicPartition topicPartition) throws IOException {
        long now = System.currentTimeMillis() / 1000L;
        long result = Long.MAX_VALUE;
        Collection<LogFilePath> paths = this.getPaths(topicPartition);
        for (LogFilePath path : paths) {
            long age;
            Long creationTime = this.mCreationTimes.get(path);
            if (creationTime == null) {
                LOG.warn("no creation time found for path " + path);
                creationTime = now;
            }
            if ((age = now - creationTime) >= result) continue;
            result = age;
        }
        if (result == Long.MAX_VALUE) {
            result = -1L;
        }
        StatsUtil.setLabel("secor.modification_age_sec." + topicPartition.getTopic() + "." + topicPartition.getPartition(), Long.toString(result));
        return result;
    }
}

