/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CompatibilityUtil {
    private static final boolean useV2;
    private static final Constructor<?> TASK_ATTEMPT_CONTEXT_CONSTRUCTOR;
    private static final Method GET_CONFIGURATION;
    private static final Method GET_COUNTER_ENUM_METHOD;
    private static final Method INCREMENT_COUNTER_METHOD;
    private static final Method GET_COUNTER_VALUE_METHOD;
    private static final String PACKAGE = "org.apache.hadoop.mapreduce";

    private static Method getMethod(String className, String methodName, Class<?> ... paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(className.startsWith(".") ? PACKAGE + className : className).getMethod(methodName, paramTypes);
    }

    public static boolean isVersion2x() {
        return useV2;
    }

    private static Object newInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate " + constructor, e);
        }
    }

    public static TaskAttemptContext newTaskAttemptContext(Configuration conf, TaskAttemptID id) {
        return (TaskAttemptContext)CompatibilityUtil.newInstance(TASK_ATTEMPT_CONTEXT_CONSTRUCTOR, conf, id);
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
    }

    public static Configuration getConfiguration(JobContext context) {
        return (Configuration)CompatibilityUtil.invoke(GET_CONFIGURATION, context, new Object[0]);
    }

    public static Counter getCounter(TaskInputOutputContext context, Enum<?> counter) {
        return (Counter)CompatibilityUtil.invoke(GET_COUNTER_ENUM_METHOD, context, counter);
    }

    public static void incrementCounter(Counter counter, long increment) {
        CompatibilityUtil.invoke(INCREMENT_COUNTER_METHOD, counter, increment);
    }

    public static long getCounterValue(Counter counter) {
        return (Long)CompatibilityUtil.invoke(GET_COUNTER_VALUE_METHOD, counter, new Object[0]);
    }

    static {
        block9: {
            boolean v2 = true;
            try {
                Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
            }
            catch (ClassNotFoundException cnfe) {
                v2 = false;
            }
            useV2 = v2;
            try {
                Class<?> taskAttemptContextCls = Class.forName(useV2 ? "org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl" : "org.apache.hadoop.mapreduce.TaskAttemptContext");
                TASK_ATTEMPT_CONTEXT_CONSTRUCTOR = taskAttemptContextCls.getConstructor(Configuration.class, TaskAttemptID.class);
                GET_CONFIGURATION = CompatibilityUtil.getMethod(".JobContext", "getConfiguration", new Class[0]);
                INCREMENT_COUNTER_METHOD = CompatibilityUtil.getMethod(".Counter", "increment", Long.TYPE);
                GET_COUNTER_VALUE_METHOD = CompatibilityUtil.getMethod(".Counter", "getValue", new Class[0]);
                if (useV2) {
                    Method get_counter;
                    try {
                        get_counter = CompatibilityUtil.getMethod(".TaskAttemptContext", "getCounter", Enum.class);
                    }
                    catch (Exception e) {
                        get_counter = CompatibilityUtil.getMethod(".TaskInputOutputContext", "getCounter", Enum.class);
                    }
                    GET_COUNTER_ENUM_METHOD = get_counter;
                    break block9;
                }
                GET_COUNTER_ENUM_METHOD = CompatibilityUtil.getMethod(".TaskInputOutputContext", "getCounter", Enum.class);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Can't run constructor ", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Can't find constructor ", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find class", e);
            }
        }
    }
}

