(ns daifu.core.pretty
  (:require [clojure.string :as string]))

(defn arrange-results [results]
  (->> (vals results)
       (apply concat)
       (sort-by #(vec (map % [:path :line])))))

(defn output-results [results]
  (println "\n")
  (println (string/join "\n" ["==========================================="
                              (str "ALL RESULTS (" (count results) ")")
                              ""]))

  (doseq [{:keys [path line column value indicator]} results]
    (println (string/join "\n" ["==========================================="
                                ""
                                (str "File : " path)
                                (str "Line : " line " :: [indicator : " (name indicator) "]")
                                ""
                                "==========================================="
                                (string/trim-newline (:actual value))
                                "-------------------------------------------"
                                (string/trim-newline (:suggested value))
                                ""])))
  (println "==========================================="))

(defn display [results]
  (-> results
      arrange-results
      output-results))
