(ns daifu.core.middleware
  (:require [cheshire.core :as json]
            [clojure.pprint :as pprint]
            [clojure.java.io :as io]
            [daifu.core.pretty :as pretty]))

(defn wrap-parse-errors [f]
  (fn [args opts]
    (let [result (f args opts)]
      (if (:errors result)
        (do (println "\nERRORS:\n\n")
            (doseq [error (:errors result)]
              (println " " error))
            (assoc-in result [:options :help] true))
        result))))

(defn wrap-parse-help [f]
  (fn [args opts]
    (let [result (f args opts)]
      (if (-> result :options :help)
        (println (format "\nUSAGE:\n\n%s\n" (:summary result)))
        result))))

(defn write-output [{:keys [root format output] :as visit} results]
  (let [path (str root (System/getProperty "path.separator") output)
        writer (if output
                 (io/writer path)
                 *out*)]
    (case format
      :json (let [output (json/generate-string results {:pretty true})]
              (if (= writer *out*)
                (println output)
                (spit path (str output))))
      :edn  (pprint/pprint results writer))))

(defn wrap-process-output [f]
  (fn [{:keys [pretty flatten] :as visit}]
    (let [results (f visit)]
      (cond pretty
            (pretty/display results)

            :else
            (write-output visit
                          (if flatten
                            (apply concat (vals results))
                            results))))))
