(ns daifu.diagnosis.target
  (:require [clojure.java.io :as io]
            [gita.core :as git]
            [daifu.diagnosis.target.project :as project]
            [daifu.diagnosis.target.files :as files]))

(defrecord Target [])

(defmethod print-method Target
  [v w]
  (.write w (str "@" (name (:type v)) " "
                 (into {} (dissoc v :type)))))

(defn target?
  "Checks if the element is of type target
   (target? {:type :project})
   => false"
  {:added "0.2"}
  [x]
  (instance? Target x))

(defn target
  "Creates a target
   (-> (target {:type :project})
       (target?))
   => true"
  {:added "0.2"}
  [m]
  (map->Target m))

(def +default-target+
  (target {:id :default
           :type :project}))

(defn read-project
  "Reads a project file from a particular repo and target
   (->> (read-project (io/file \".\") (target +default-target+))
        keys
        sort)
   => (contains [:dependencies :description :documentation :group
                 :license :name :plugins :profiles :root :source-paths
                 :target :target-path :test-paths :url :version] :gaps-ok)"
  {:added "0.2"}
  [repo target]
  (project/read-project repo target))

(defn list-files
  "Reads a project file from a particular repo target
   (-> (list-files (io/file \".\") (target +default-target+))
       count)
   => (not zero?)"
  {:added "0.2"}
  [repo target]
  (files/list-files repo target))

(defn pick-files
  "Reads a project file from a particular repo target
   (pick-files (io/file \".\") (target +default-target+))
   => (fn [fs]
        (every? #(.endsWith % \".clj\") fs))"
  {:added "0.2"}
  [repo target]
  (files/pick-files repo target))

(defn retrieve-file
  "Reads a project file from a particular repo target
   (-> (retrieve-file (io/file \".\")
                      (target (assoc +default-target+ :path \"project.clj\")))
       slurp
       read-string
       second)
   => 'helpshift/daifu"
  {:added "0.2"}
  [repo target]
  (files/retrieve-file repo target))
