/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.xxhash;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.xxhash.XXH32State;
import org.lwjgl.system.xxhash.XXH64State;

public class XXHash {
    public static final int OK = 0;
    public static final int ERROR = 1;

    protected XXHash() {
        throw new UnsupportedOperationException();
    }

    public static native int nXXH32(long var0, long var2, int var4);

    public static int XXH32(ByteBuffer input, long length, int seed) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)input, length);
        }
        return XXHash.nXXH32(MemoryUtil.memAddress(input), length, seed);
    }

    public static int XXH32(ByteBuffer input, int seed) {
        return XXHash.nXXH32(MemoryUtil.memAddress(input), input.remaining(), seed);
    }

    public static native long nXXH64(long var0, long var2, long var4);

    public static long XXH64(ByteBuffer input, long length, long seed) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)input, length);
        }
        return XXHash.nXXH64(MemoryUtil.memAddress(input), length, seed);
    }

    public static long XXH64(ByteBuffer input, long seed) {
        return XXHash.nXXH64(MemoryUtil.memAddress(input), input.remaining(), seed);
    }

    public static native long nXXH32_createState();

    public static XXH32State XXH32_createState() {
        long __result = XXHash.nXXH32_createState();
        return new XXH32State(__result);
    }

    public static native int nXXH32_freeState(long var0);

    public static int XXH32_freeState(XXH32State statePtr) {
        return XXHash.nXXH32_freeState(statePtr.address());
    }

    public static native long nXXH64_createState();

    public static XXH64State XXH64_createState() {
        long __result = XXHash.nXXH64_createState();
        return new XXH64State(__result);
    }

    public static native int nXXH64_freeState(long var0);

    public static int XXH64_freeState(XXH64State statePtr) {
        return XXHash.nXXH64_freeState(statePtr.address());
    }

    public static native int nXXH32_reset(long var0, int var2);

    public static int XXH32_reset(XXH32State statePtr, int seed) {
        return XXHash.nXXH32_reset(statePtr.address(), seed);
    }

    public static native int nXXH32_update(long var0, long var2, long var4);

    public static int XXH32_update(XXH32State statePtr, ByteBuffer input, long length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)input, length);
        }
        return XXHash.nXXH32_update(statePtr.address(), MemoryUtil.memAddress(input), length);
    }

    public static int XXH32_update(XXH32State statePtr, ByteBuffer input) {
        return XXHash.nXXH32_update(statePtr.address(), MemoryUtil.memAddress(input), input.remaining());
    }

    public static native int nXXH32_digest(long var0);

    public static int XXH32_digest(XXH32State statePtr) {
        return XXHash.nXXH32_digest(statePtr.address());
    }

    public static native int nXXH64_reset(long var0, long var2);

    public static int XXH64_reset(XXH64State statePtr, long seed) {
        return XXHash.nXXH64_reset(statePtr.address(), seed);
    }

    public static native int nXXH64_update(long var0, long var2, long var4);

    public static int XXH64_update(XXH64State statePtr, ByteBuffer input, long length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)input, length);
        }
        return XXHash.nXXH64_update(statePtr.address(), MemoryUtil.memAddress(input), length);
    }

    public static int XXH64_update(XXH64State statePtr, ByteBuffer input) {
        return XXHash.nXXH64_update(statePtr.address(), MemoryUtil.memAddress(input), input.remaining());
    }

    public static native long nXXH64_digest(long var0);

    public static long XXH64_digest(XXH64State statePtr) {
        return XXHash.nXXH64_digest(statePtr.address());
    }

    static {
        Library.initialize();
    }
}

