/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class POINT
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;

    POINT(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public POINT(long struct) {
        this(struct, null);
    }

    public POINT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return POINT.nx(this.address());
    }

    public int y() {
        return POINT.ny(this.address());
    }

    public POINT x(int value) {
        POINT.nx(this.address(), value);
        return this;
    }

    public POINT y(int value) {
        POINT.ny(this.address(), value);
        return this;
    }

    public POINT set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public POINT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public POINT set(POINT src) {
        return this.nset(src.address());
    }

    public POINT set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static POINT malloc() {
        return new POINT(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static POINT calloc() {
        return new POINT(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static POINT create() {
        return new POINT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = POINT.__struct(POINT.__member(4), POINT.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<POINT, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected POINT newInstance(long address) {
            return new POINT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int x() {
            return POINT.nx(this.address());
        }

        public int y() {
            return POINT.ny(this.address());
        }

        public Buffer x(int value) {
            POINT.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            POINT.ny(this.address(), value);
            return this;
        }
    }
}

