/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.PIXELFORMATDESCRIPTOR;
import org.lwjgl.system.windows.POINT;

public class GDI32 {
    public static final int PFD_DOUBLEBUFFER = 1;
    public static final int PFD_STEREO = 2;
    public static final int PFD_DRAW_TO_WINDOW = 4;
    public static final int PFD_DRAW_TO_BITMAP = 8;
    public static final int PFD_SUPPORT_GDI = 16;
    public static final int PFD_SUPPORT_OPENGL = 32;
    public static final int PFD_GENERIC_FORMAT = 64;
    public static final int PFD_NEED_PALETTE = 128;
    public static final int PFD_NEED_SYSTEM_PALETTE = 256;
    public static final int PFD_SWAP_EXCHANGE = 512;
    public static final int PFD_SWAP_COPY = 1024;
    public static final int PFD_SWAP_LAYER_BUFFERS = 2048;
    public static final int PFD_GENERIC_ACCELERATED = 4096;
    public static final int PFD_SUPPORT_DIRECTDRAW = 8192;
    public static final int PFD_DIRECT3D_ACCELERATED = 16384;
    public static final int PFD_SUPPORT_COMPOSITION = 32768;
    public static final int PFD_DEPTH_DONTCARE = 0x20000000;
    public static final int PFD_DOUBLEBUFFER_DONTCARE = 0x40000000;
    public static final int PFD_STEREO_DONTCARE = Integer.MIN_VALUE;
    public static final int PFD_TYPE_RGBA = 0;
    public static final int PFD_TYPE_COLORINDEX = 1;
    public static final int PFD_MAIN_PLANE = 0;
    public static final int PFD_OVERLAY_PLANE = 1;
    public static final int PFD_UNDERLAY_PLANE = -1;
    public final long CreateCompatibleDC;
    public final long DeleteDC;
    public final long CancelDC;
    public final long SaveDC;
    public final long RestoreDC;
    public final long GetDCOrgEx;
    public final long GetDeviceCaps;
    public final long GetDeviceGammaRamp;
    public final long SetDeviceGammaRamp;
    public final long ChoosePixelFormat;
    public final long DescribePixelFormat;
    public final long GetPixelFormat;
    public final long SetPixelFormat;
    public final long SwapBuffers;
    private static final SharedLibrary GDI32 = Library.loadNative("gdi32");
    private static final GDI32 instance = new GDI32(GDI32);

    protected GDI32() {
        throw new UnsupportedOperationException();
    }

    public GDI32(FunctionProvider provider) {
        this.CreateCompatibleDC = Checks.checkFunctionAddress(provider.getFunctionAddress("CreateCompatibleDC"));
        this.DeleteDC = Checks.checkFunctionAddress(provider.getFunctionAddress("DeleteDC"));
        this.CancelDC = Checks.checkFunctionAddress(provider.getFunctionAddress("CancelDC"));
        this.SaveDC = Checks.checkFunctionAddress(provider.getFunctionAddress("SaveDC"));
        this.RestoreDC = Checks.checkFunctionAddress(provider.getFunctionAddress("RestoreDC"));
        this.GetDCOrgEx = Checks.checkFunctionAddress(provider.getFunctionAddress("GetDCOrgEx"));
        this.GetDeviceCaps = Checks.checkFunctionAddress(provider.getFunctionAddress("GetDeviceCaps"));
        this.GetDeviceGammaRamp = Checks.checkFunctionAddress(provider.getFunctionAddress("GetDeviceGammaRamp"));
        this.SetDeviceGammaRamp = Checks.checkFunctionAddress(provider.getFunctionAddress("SetDeviceGammaRamp"));
        this.ChoosePixelFormat = Checks.checkFunctionAddress(provider.getFunctionAddress("ChoosePixelFormat"));
        this.DescribePixelFormat = Checks.checkFunctionAddress(provider.getFunctionAddress("DescribePixelFormat"));
        this.GetPixelFormat = Checks.checkFunctionAddress(provider.getFunctionAddress("GetPixelFormat"));
        this.SetPixelFormat = Checks.checkFunctionAddress(provider.getFunctionAddress("SetPixelFormat"));
        this.SwapBuffers = Checks.checkFunctionAddress(provider.getFunctionAddress("SwapBuffers"));
    }

    public static SharedLibrary getLibrary() {
        return GDI32;
    }

    public static GDI32 getInstance() {
        return instance;
    }

    public static long CreateCompatibleDC(long hdc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().CreateCompatibleDC;
        return JNI.callPP(__functionAddress, hdc);
    }

    public static int DeleteDC(long hdc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().DeleteDC;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPI(__functionAddress, hdc);
    }

    public static int CancelDC(long hdc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().CancelDC;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPI(__functionAddress, hdc);
    }

    public static int SaveDC(long hdc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().SaveDC;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPI(__functionAddress, hdc);
    }

    public static int RestoreDC(long hdc, int savedDC) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().RestoreDC;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPII(__functionAddress, hdc, savedDC);
    }

    public static int nGetDCOrgEx(long hdc, long point) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().GetDCOrgEx;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPPI(__functionAddress, hdc, point);
    }

    public static int GetDCOrgEx(long hdc, POINT point) {
        return org.lwjgl.system.windows.GDI32.nGetDCOrgEx(hdc, point.address());
    }

    public static int GetDeviceCaps(long hdc, int index) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().GetDeviceCaps;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPII(__functionAddress, hdc, index);
    }

    public static int GetDeviceGammaRamp(long hdc, long lpRamp) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().GetDeviceGammaRamp;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkPointer(lpRamp);
        }
        return JNI.callPPI(__functionAddress, hdc, lpRamp);
    }

    public static int SetDeviceGammaRamp(long hdc, long lpRamp) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().SetDeviceGammaRamp;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
            Checks.checkPointer(lpRamp);
        }
        return JNI.callPPI(__functionAddress, hdc, lpRamp);
    }

    public static int nChoosePixelFormat(long hdc, long pixelFormatDescriptor) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().ChoosePixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPPI(__functionAddress, hdc, pixelFormatDescriptor);
    }

    public static int ChoosePixelFormat(long hdc, PIXELFORMATDESCRIPTOR pixelFormatDescriptor) {
        return org.lwjgl.system.windows.GDI32.nChoosePixelFormat(hdc, pixelFormatDescriptor.address());
    }

    public static int nDescribePixelFormat(long hdc, int pixelFormat, int bytes, long pixelFormatDescriptor) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().DescribePixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIIPI(__functionAddress, hdc, pixelFormat, bytes, pixelFormatDescriptor);
    }

    public static int DescribePixelFormat(long hdc, int pixelFormat, int bytes, PIXELFORMATDESCRIPTOR pixelFormatDescriptor) {
        return org.lwjgl.system.windows.GDI32.nDescribePixelFormat(hdc, pixelFormat, bytes, pixelFormatDescriptor == null ? 0L : pixelFormatDescriptor.address());
    }

    public static int DescribePixelFormat(long hdc, int pixelFormat, PIXELFORMATDESCRIPTOR pixelFormatDescriptor) {
        return org.lwjgl.system.windows.GDI32.nDescribePixelFormat(hdc, pixelFormat, PIXELFORMATDESCRIPTOR.SIZEOF, pixelFormatDescriptor == null ? 0L : pixelFormatDescriptor.address());
    }

    public static int GetPixelFormat(long hdc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().GetPixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPI(__functionAddress, hdc);
    }

    public static int nSetPixelFormat(long hdc, int pixelFormat, long pixelFormatDescriptor) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().SetPixelFormat;
        if (Checks.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return JNI.callPIPI(__functionAddress, hdc, pixelFormat, pixelFormatDescriptor);
    }

    public static int SetPixelFormat(long hdc, int pixelFormat, PIXELFORMATDESCRIPTOR pixelFormatDescriptor) {
        return org.lwjgl.system.windows.GDI32.nSetPixelFormat(hdc, pixelFormat, pixelFormatDescriptor == null ? 0L : pixelFormatDescriptor.address());
    }

    public static int SwapBuffers(long dc) {
        long __functionAddress = org.lwjgl.system.windows.GDI32.getInstance().SwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(dc);
        }
        return JNI.callPI(__functionAddress, dc);
    }
}

