/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.linux.DynamicLinkLoader;

public class LinuxLibrary
extends SharedLibrary.Default {
    private final long handle;

    public LinuxLibrary(String name) {
        super(name);
        this.handle = DynamicLinkLoader.dlopen(name, 257);
        if (this.handle == 0L) {
            throw new RuntimeException("Failed to dynamically load library: " + name + "(error = " + DynamicLinkLoader.dlerror() + ")");
        }
        APIUtil.apiLog("Loaded native library: " + name);
    }

    @Override
    public long address() {
        return this.handle;
    }

    @Override
    public long getFunctionAddress(CharSequence name) {
        return DynamicLinkLoader.dlsym(this.handle, name);
    }

    @Override
    protected void destroy() {
        DynamicLinkLoader.dlclose(this.handle);
    }
}

