/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.Checks;
import org.lwjgl.system.Pointer;

public abstract class PointerWrapper
implements Pointer {
    protected final long pointer;

    protected PointerWrapper(long pointer) {
        if (Checks.CHECKS && pointer == 0L) {
            throw new NullPointerException();
        }
        this.pointer = pointer;
    }

    @Override
    public final long address() {
        return this.pointer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointerWrapper)) {
            return false;
        }
        PointerWrapper that = (PointerWrapper)o;
        return this.pointer == that.pointer;
    }

    public int hashCode() {
        return (int)(this.pointer ^ this.pointer >>> 32);
    }

    public String toString() {
        return String.format("%s pointer [0x%X]", this.getClass().getSimpleName(), this.pointer);
    }
}

