/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackContext
extends Struct {
    public static final int SIZEOF = STBTTPackContext.offsets();

    private static native int offsets();

    STBTTPackContext(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBTTPackContext(long struct) {
        this(struct, null);
    }

    public STBTTPackContext(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static STBTTPackContext malloc() {
        return new STBTTPackContext(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackContext calloc() {
        return new STBTTPackContext(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackContext create() {
        return new STBTTPackContext(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static final class Buffer
    extends StructBuffer<STBTTPackContext, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBTTPackContext newInstance(long address) {
            return new STBTTPackContext(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }
    }
}

